/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.envers.AuditTable;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesHolder;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;

public class ClassAuditingData
implements AuditedPropertiesHolder {
    private final Map<String, PropertyAuditingData> properties = new HashMap<String, PropertyAuditingData>();
    private final Map<String, String> secondaryTableDictionary = new HashMap<String, String>();
    private AuditTable auditTable;
    private boolean defaultAudited;

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public void addPropertyAuditingData(String propertyName, PropertyAuditingData auditingData) {
        this.properties.put(propertyName, auditingData);
    }

    @Override
    public PropertyAuditingData getPropertyAuditingData(String propertyName) {
        return this.properties.get(propertyName);
    }

    public Iterable<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Map<String, String> getSecondaryTableDictionary() {
        return this.secondaryTableDictionary;
    }

    public AuditTable getAuditTable() {
        return this.auditTable;
    }

    public void setAuditTable(AuditTable auditTable) {
        this.auditTable = auditTable;
    }

    public void setDefaultAudited(boolean defaultAudited) {
        this.defaultAudited = defaultAudited;
    }

    public boolean isAudited() {
        return this.defaultAudited || this.properties.size() > 0;
    }

    @Override
    public boolean contains(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public Iterable<String> getNonSyntheticPropertyNames() {
        return this.properties.entrySet().stream().filter(e -> !((PropertyAuditingData)e.getValue()).isSynthetic()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public Iterable<PropertyAuditingData> getSyntheticProperties() {
        return this.properties.values().stream().filter(p -> p.isSynthetic()).collect(Collectors.toList());
    }
}

