/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import javax.persistence.MappedSuperclass;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.Audited;
import org.hibernate.envers.boot.spi.AuditMetadataBuildingOptions;
import org.hibernate.envers.configuration.internal.metadata.MetadataTools;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesHolder;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.PersistentPropertiesSource;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;

public class ComponentAuditedPropertiesReader
extends AuditedPropertiesReader {
    public ComponentAuditedPropertiesReader(PersistentPropertiesSource persistentPropertiesSource, AuditedPropertiesHolder auditedPropertiesHolder, AuditMetadataBuildingOptions options, ReflectionManager reflectionManager, String propertyNamePrefix) {
        super(persistentPropertiesSource, auditedPropertiesHolder, options, reflectionManager, propertyNamePrefix);
    }

    @Override
    protected void addPropertiesFromClass(XClass clazz) {
        Audited allClassAudited = this.computeAuditConfiguration(clazz);
        this.addFromProperties(clazz.getDeclaredProperties("field"), "field", this.fieldAccessedPersistentProperties, allClassAudited);
        this.addFromProperties(clazz.getDeclaredProperties("property"), "property", this.propertyAccessedPersistentProperties, allClassAudited);
        XClass superclazz = clazz.getSuperclass();
        if (!clazz.isInterface() && !"java.lang.Object".equals(superclazz.getName())) {
            this.addPropertiesFromClass(superclazz);
        }
    }

    @Override
    protected boolean checkAudited(XProperty property, PropertyAuditingData propertyData, String propertyName, Audited allClassAudited, String modifiedFlagSuffix) {
        Audited aud = (Audited)property.getAnnotation(Audited.class);
        if (aud != null) {
            propertyData.setRelationTargetAuditMode(aud.targetAuditMode());
            propertyData.setUsingModifiedFlag(this.checkUsingModifiedFlag(aud));
            if (aud.modifiedColumnName() != null && !"".equals(aud.modifiedColumnName())) {
                propertyData.setModifiedFlagName(aud.modifiedColumnName());
            } else {
                propertyData.setModifiedFlagName(MetadataTools.getModifiedFlagPropertyName(propertyName, modifiedFlagSuffix));
            }
        } else {
            XClass declaringClazz = property.getDeclaringClass();
            ComponentAuditingData auditingData = (ComponentAuditingData)this.auditedPropertiesHolder;
            boolean clazzAuditedOverride = false;
            boolean clazzNotAuditedOverride = false;
            for (AuditOverride auditOverride : auditingData.getAuditingOverrides()) {
                if (auditOverride.forClass() == Void.TYPE) continue;
                String clazzName = auditOverride.forClass().getName();
                if (!declaringClazz.getName().equals(clazzName)) continue;
                if (!auditOverride.isAudited()) {
                    if ("".equals(auditOverride.name())) {
                        clazzNotAuditedOverride = true;
                    }
                    if (!property.getName().equals(auditOverride.name())) continue;
                    return false;
                }
                if ("".equals(auditOverride.name())) {
                    clazzAuditedOverride = true;
                }
                if (!property.getName().equals(auditOverride.name())) continue;
                return true;
            }
            if (clazzNotAuditedOverride || this.overriddenNotAuditedProperties.contains(property) || this.overriddenNotAuditedClasses.contains(declaringClazz)) {
                return false;
            }
            if (clazzAuditedOverride || this.overriddenAuditedProperties.contains(property) || this.overriddenAuditedClasses.contains(declaringClazz)) {
                return true;
            }
            if (declaringClazz.isAnnotationPresent(MappedSuperclass.class)) {
                return false;
            }
        }
        return true;
    }
}

