/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.RelationTargetNotFoundAction;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.mapping.Value;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class PropertyAuditingData {
    private String name;
    private String beanName;
    private String mapKey;
    private AuditJoinTable joinTable;
    private String accessType;
    private final List<AuditOverride> auditJoinTableOverrides = new ArrayList<AuditOverride>(0);
    private RelationTargetAuditMode relationTargetAuditMode;
    private RelationTargetNotFoundAction relationTargetNotFoundAction;
    private String auditMappedBy;
    private String relationMappedBy;
    private String positionMappedBy;
    private boolean forceInsertable;
    private boolean usingModifiedFlag;
    private String modifiedFlagName;
    private Value value;
    private boolean synthetic;

    public PropertyAuditingData() {
    }

    public PropertyAuditingData(String name, String accessType, RelationTargetAuditMode relationTargetAuditMode, String auditMappedBy, String positionMappedBy, boolean forceInsertable) {
        this(name, accessType, relationTargetAuditMode, RelationTargetNotFoundAction.ERROR, auditMappedBy, positionMappedBy, forceInsertable, false, null);
    }

    public PropertyAuditingData(String name, String accessType, RelationTargetAuditMode relationTargetAuditMode, RelationTargetNotFoundAction relationTargetNotFoundAction, String auditMappedBy, String positionMappedBy, boolean forceInsertable, boolean synthetic, Value value) {
        this.name = name;
        this.beanName = name;
        this.accessType = accessType;
        this.relationTargetAuditMode = relationTargetAuditMode;
        this.relationTargetNotFoundAction = relationTargetNotFoundAction;
        this.auditMappedBy = auditMappedBy;
        this.positionMappedBy = positionMappedBy;
        this.forceInsertable = forceInsertable;
        this.synthetic = synthetic;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public void setMapKey(String mapKey) {
        this.mapKey = mapKey;
    }

    public AuditJoinTable getJoinTable() {
        return this.joinTable;
    }

    public void setJoinTable(AuditJoinTable joinTable) {
        this.joinTable = joinTable;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    public PropertyData getPropertyData() {
        return this.resolvePropertyData(null);
    }

    public PropertyData resolvePropertyData(JavaTypeDescriptor javaTypeDescriptor) {
        return new PropertyData(this.name, this.beanName, this.accessType, this.usingModifiedFlag, this.modifiedFlagName, this.synthetic, javaTypeDescriptor);
    }

    public PropertyData resolvePropertyData(JavaTypeDescriptor propertyDescriptor, JavaTypeDescriptor virtualDescriptor) {
        return new PropertyData(this.name, this.beanName, this.accessType, this.usingModifiedFlag, this.modifiedFlagName, this.synthetic, propertyDescriptor, virtualDescriptor.getJavaType());
    }

    public List<AuditOverride> getAuditingOverrides() {
        return this.auditJoinTableOverrides;
    }

    public String getAuditMappedBy() {
        return this.auditMappedBy;
    }

    public void setAuditMappedBy(String auditMappedBy) {
        this.auditMappedBy = auditMappedBy;
    }

    public String getRelationMappedBy() {
        return this.relationMappedBy;
    }

    public void setRelationMappedBy(String relationMappedBy) {
        this.relationMappedBy = relationMappedBy;
    }

    public String getPositionMappedBy() {
        return this.positionMappedBy;
    }

    public void setPositionMappedBy(String positionMappedBy) {
        this.positionMappedBy = positionMappedBy;
    }

    public boolean isForceInsertable() {
        return this.forceInsertable;
    }

    public void setForceInsertable(boolean forceInsertable) {
        this.forceInsertable = forceInsertable;
    }

    public boolean isUsingModifiedFlag() {
        return this.usingModifiedFlag;
    }

    public void setUsingModifiedFlag(boolean usingModifiedFlag) {
        this.usingModifiedFlag = usingModifiedFlag;
    }

    public String getModifiedFlagName() {
        return this.modifiedFlagName;
    }

    public void setModifiedFlagName(String modifiedFlagName) {
        this.modifiedFlagName = modifiedFlagName;
    }

    public void addAuditingOverride(AuditOverride annotation) {
        if (annotation != null) {
            String overrideName = annotation.name();
            boolean present = false;
            for (AuditOverride current : this.auditJoinTableOverrides) {
                if (!current.name().equals(overrideName)) continue;
                present = true;
                break;
            }
            if (!present) {
                this.auditJoinTableOverrides.add(annotation);
            }
        }
    }

    public void addAuditingOverrides(AuditOverrides annotationOverrides) {
        if (annotationOverrides != null) {
            for (AuditOverride annotation : annotationOverrides.value()) {
                this.addAuditingOverride(annotation);
            }
        }
    }

    public RelationTargetAuditMode getRelationTargetAuditMode() {
        return this.relationTargetAuditMode;
    }

    public void setRelationTargetAuditMode(RelationTargetAuditMode relationTargetAuditMode) {
        this.relationTargetAuditMode = relationTargetAuditMode;
    }

    public RelationTargetNotFoundAction getRelationTargetNotFoundAction() {
        return this.relationTargetNotFoundAction;
    }

    public void setRelationTargetNotFoundAction(RelationTargetNotFoundAction relationTargetNotFoundAction) {
        this.relationTargetNotFoundAction = relationTargetNotFoundAction;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public Value getValue() {
        return this.value;
    }
}

