/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.enhanced;

import org.hibernate.HibernateException;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.MappedAuxiliaryDatabaseObject;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.id.enhanced.SequenceStructure;
import org.hibernate.naming.spi.QualifiedName;

public class OrderedSequenceStructure
extends SequenceStructure {
    private static final String ORDER = " ORDER";
    private MappedAuxiliaryDatabaseObject sequenceObject = new OrderedSequence();

    public OrderedSequenceStructure(JdbcEnvironment jdbcEnvironment, QualifiedName qualifiedSequenceName, int initialValue, int incrementSize, Class numberType) {
        super(jdbcEnvironment, qualifiedSequenceName, initialValue, incrementSize, numberType);
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return this.sequenceObject.sqlCreateStrings(dialect);
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return this.sequenceObject.sqlDropStrings(dialect);
    }

    @Override
    protected void buildSequence(Database database) {
        database.addAuxiliaryDatabaseObject(this.sequenceObject);
        this.sequenceName = database.getJdbcEnvironment().getQualifiedObjectNameFormatter().format(this.getQualifiedName(), database.getJdbcEnvironment().getDialect());
    }

    private class OrderedSequence
    implements MappedAuxiliaryDatabaseObject {
        private OrderedSequence() {
        }

        @Override
        public String getIdentifier() {
            return OrderedSequenceStructure.this.getName();
        }

        @Override
        public boolean appliesToDialect(Dialect dialect) {
            return true;
        }

        @Override
        public boolean beforeTablesOnCreation() {
            return true;
        }

        @Override
        public String[] sqlCreateStrings(Dialect dialect) {
            String[] createStrings = dialect.getCreateSequenceStrings(OrderedSequenceStructure.this.getName(), OrderedSequenceStructure.this.getInitialValue(), OrderedSequenceStructure.this.getSourceIncrementSize());
            if (dialect instanceof Oracle8iDialect) {
                for (int i = 0; i < createStrings.length; ++i) {
                    createStrings[i] = createStrings[i] + OrderedSequenceStructure.ORDER;
                }
            }
            return createStrings;
        }

        @Override
        public String[] sqlDropStrings(Dialect dialect) {
            return dialect.getDropSequenceStrings(OrderedSequenceStructure.this.getName());
        }
    }
}

