/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event.internal;

import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.event.spi.AbstractEnversEventListener;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.envers.internal.synchronization.work.DelWorkUnit;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;

public class EnversPostDeleteEventListenerImpl
extends AbstractEnversEventListener
implements PostDeleteEventListener {
    public EnversPostDeleteEventListenerImpl(AuditService auditService) {
        super(auditService);
    }

    @Override
    public void onPostDelete(PostDeleteEvent event) {
        String entityName = event.getDescriptor().getEntityName();
        if (this.getAuditService().getEntityBindings().isVersioned(entityName)) {
            this.checkIfTransactionInProgress(event.getSession());
            AuditProcess auditProcess = this.getAuditService().getAuditProcess(event.getSession());
            DelWorkUnit workUnit = new DelWorkUnit(event.getSession(), event.getDescriptor().getEntityName(), this.getAuditService(), event.getId(), event.getDescriptor(), event.getDeletedState());
            auditProcess.addWorkUnit(workUnit);
            if (workUnit.containsWork()) {
                this.generateBidirectionalCollectionChangeWorkUnits(auditProcess, event.getDescriptor(), entityName, null, event.getDeletedState(), event.getSession());
            }
        }
    }

    @Override
    public boolean requiresPostCommitHandling(EntityTypeDescriptor descriptor) {
        return this.getAuditService().getEntityBindings().isVersioned(descriptor.getEntityName());
    }
}

