/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event.internal;

import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.event.spi.AbstractEnversEventListener;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.envers.internal.synchronization.work.AddWorkUnit;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;

public class EnversPostInsertEventListenerImpl
extends AbstractEnversEventListener
implements PostInsertEventListener {
    public EnversPostInsertEventListenerImpl(AuditService auditService) {
        super(auditService);
    }

    @Override
    public void onPostInsert(PostInsertEvent event) {
        String entityName = event.getDescriptor().getEntityName();
        if (this.getAuditService().getEntityBindings().isVersioned(entityName)) {
            this.checkIfTransactionInProgress(event.getSession());
            AuditProcess auditProcess = this.getAuditService().getAuditProcess(event.getSession());
            AddWorkUnit workUnit = new AddWorkUnit(event.getSession(), event.getDescriptor().getEntityName(), this.getAuditService(), event.getId(), event.getDescriptor(), event.getState());
            auditProcess.addWorkUnit(workUnit);
            if (workUnit.containsWork()) {
                this.generateBidirectionalCollectionChangeWorkUnits(auditProcess, event.getDescriptor(), entityName, event.getState(), null, event.getSession());
            }
        }
    }

    @Override
    public boolean requiresPostCommitHandling(EntityTypeDescriptor descriptor) {
        return this.getAuditService().getEntityBindings().isVersioned(descriptor.getEntityName());
    }
}

