/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event.internal;

import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.event.spi.AbstractEnversUpdateEventListener;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.envers.internal.synchronization.work.ModWorkUnit;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;

public class EnversPostUpdateEventListenerImpl
extends AbstractEnversUpdateEventListener
implements PostUpdateEventListener {
    public EnversPostUpdateEventListenerImpl(AuditService auditService) {
        super(auditService);
    }

    @Override
    public void onPostUpdate(PostUpdateEvent event) {
        String entityName = event.getDescriptor().getEntityName();
        if (this.getAuditService().getEntityBindings().isVersioned(entityName)) {
            this.checkIfTransactionInProgress(event.getSession());
            AuditProcess auditProcess = this.getAuditService().getAuditProcess(event.getSession());
            Object[] oldState = this.getOldDBState(auditProcess, entityName, event);
            Object[] newDbState = this.postUpdateDBState(event);
            ModWorkUnit workUnit = new ModWorkUnit(event.getSession(), event.getDescriptor().getEntityName(), this.getAuditService(), event.getId(), event.getDescriptor(), newDbState, oldState);
            auditProcess.addWorkUnit(workUnit);
            if (workUnit.containsWork()) {
                this.generateBidirectionalCollectionChangeWorkUnits(auditProcess, event.getDescriptor(), entityName, newDbState, oldState, event.getSession());
            }
        }
    }

    private Object[] getOldDBState(AuditProcess auditProcess, String entityName, PostUpdateEvent event) {
        if (this.isDetachedEntityUpdate(entityName, event.getOldState())) {
            return auditProcess.getCachedEntityState(event.getId(), entityName);
        }
        return event.getOldState();
    }

    private Object[] postUpdateDBState(PostUpdateEvent event) {
        Object[] newDbState = (Object[])event.getState().clone();
        if (event.getOldState() != null) {
            EntityTypeDescriptor entityDescriptor = event.getDescriptor();
            entityDescriptor.visitStateArrayContributors(contributor -> {
                int index = contributor.getStateArrayPosition();
                if (!contributor.isUpdatable()) {
                    newDbState[index] = event.getOldState()[index];
                }
            });
        }
        return newDbState;
    }

    @Override
    public boolean requiresPostCommitHandling(EntityTypeDescriptor descriptor) {
        return this.getAuditService().getEntityBindings().isVersioned(descriptor.getEntityName());
    }
}

