/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event.internal;

import java.io.Serializable;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.event.spi.AbstractEnversCollectionEventListener;
import org.hibernate.event.spi.PreCollectionRemoveEvent;
import org.hibernate.event.spi.PreCollectionRemoveEventListener;

public class EnversPreCollectionRemoveEventListenerImpl
extends AbstractEnversCollectionEventListener
implements PreCollectionRemoveEventListener {
    public EnversPreCollectionRemoveEventListenerImpl(AuditService auditService) {
        super(auditService);
    }

    @Override
    public void onPreRemoveCollection(PreCollectionRemoveEvent event) {
        CollectionEntry collectionEntry = this.getCollectionEntry(event);
        if (collectionEntry != null) {
            if (!collectionEntry.getLoadedCollectionDescriptor().isInverse()) {
                Serializable oldColl = collectionEntry.getSnapshot();
                if (!event.getCollection().wasInitialized() && this.shouldGenerateRevision(event)) {
                    oldColl = this.initializeCollection(event);
                }
                this.onCollectionAction(event, null, oldColl, collectionEntry);
            } else if (this.getAuditService().getOptions().isGlobalWithModifiedFlagEnabled()) {
                this.initializeCollection(event);
            }
        }
    }
}

