/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event.internal;

import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.event.spi.AbstractEnversUpdateEventListener;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;

public class EnversPreUpdateEventListenerImpl
extends AbstractEnversUpdateEventListener
implements PreUpdateEventListener {
    public EnversPreUpdateEventListenerImpl(AuditService auditService) {
        super(auditService);
    }

    @Override
    public boolean onPreUpdate(PreUpdateEvent event) {
        String entityName = event.getDescriptor().getEntityName();
        if (this.getAuditService().getEntityBindings().isVersioned(entityName)) {
            this.checkIfTransactionInProgress(event.getSession());
            if (this.isDetachedEntityUpdate(entityName, event.getOldState())) {
                AuditProcess auditProcess = this.getAuditService().getAuditProcess(event.getSession());
                auditProcess.cacheEntityState(event.getId(), entityName, event.getDescriptor().getDatabaseSnapshot(event.getId(), event.getSession()));
            }
        }
        return false;
    }
}

