/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event.spi;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.event.spi.AbstractEnversEventListener;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.entities.RelationType;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.envers.internal.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.internal.synchronization.work.FakeBidirectionalRelationWorkUnit;
import org.hibernate.envers.internal.synchronization.work.PersistentCollectionChangeWorkUnit;
import org.hibernate.event.spi.AbstractCollectionEvent;
import org.hibernate.metamodel.model.domain.spi.CollectionElement;

public abstract class AbstractEnversCollectionEventListener
extends AbstractEnversEventListener {
    protected AbstractEnversCollectionEventListener(AuditService auditService) {
        super(auditService);
    }

    protected final CollectionEntry getCollectionEntry(AbstractCollectionEvent event) {
        return event.getSession().getPersistenceContext().getCollectionEntry(event.getCollection());
    }

    protected final void onCollectionAction(AbstractCollectionEvent event, PersistentCollection newColl, Serializable oldColl, CollectionEntry collectionEntry) {
        if (this.shouldGenerateRevision(event)) {
            this.checkIfTransactionInProgress(event.getSession());
            AuditProcess auditProcess = this.getAuditService().getAuditProcess(event.getSession());
            String entityName = event.getAffectedOwnerEntityName();
            String referencingPropertyName = this.resolveReferencingPropertyName(entityName, collectionEntry);
            RelationDescription rd = this.searchForRelationDescription(entityName, referencingPropertyName);
            if (rd != null && rd.getMappedByPropertyName() != null) {
                this.generateFakeBidirecationalRelationWorkUnits(auditProcess, newColl, oldColl, entityName, referencingPropertyName, event, rd);
            } else {
                PersistentCollectionChangeWorkUnit workUnit = new PersistentCollectionChangeWorkUnit(event.getSession(), entityName, this.getAuditService(), newColl, collectionEntry, oldColl, event.getAffectedOwnerIdOrNull(), referencingPropertyName);
                auditProcess.addWorkUnit(workUnit);
                if (workUnit.containsWork()) {
                    auditProcess.addWorkUnit(new CollectionChangeWorkUnit(event.getSession(), event.getAffectedOwnerEntityName(), referencingPropertyName, this.getAuditService(), event.getAffectedOwnerIdOrNull(), event.getAffectedOwnerOrNull()));
                    this.generateBidirectionalCollectionChangeWorkUnits(auditProcess, event, workUnit, rd);
                }
            }
        }
    }

    protected final void onCollectionActionInversed(AbstractCollectionEvent event, PersistentCollection newColl, Serializable oldColl, CollectionEntry collectionEntry) {
        String referencingPropertyName;
        String entityName;
        RelationDescription rd;
        if (this.shouldGenerateRevision(event) && (rd = this.searchForRelationDescription(entityName = event.getAffectedOwnerEntityName(), referencingPropertyName = this.resolveReferencingPropertyName(entityName, collectionEntry))) != null && rd.getRelationType().equals((Object)RelationType.TO_MANY_NOT_OWNING) && rd.isIndexed()) {
            this.onCollectionAction(event, newColl, oldColl, collectionEntry);
        }
    }

    protected Serializable initializeCollection(AbstractCollectionEvent event) {
        event.getCollection().forceInitialization();
        return event.getCollection().getStoredSnapshot();
    }

    protected boolean shouldGenerateRevision(AbstractCollectionEvent event) {
        String entityName = event.getAffectedOwnerEntityName();
        if (this.getAuditService().getEntityBindings().isVersioned(entityName)) {
            CollectionEntry collectionEntry = this.getCollectionEntry(event);
            if (this.isInverse(collectionEntry) || this.isOneToMany(collectionEntry)) {
                return this.getAuditService().getOptions().isRevisionOnCollectionChangeEnabled();
            }
            return true;
        }
        return false;
    }

    private RelationDescription searchForRelationDescription(String entityName, String referencingPropertyName) {
        String propertyName;
        EntityConfiguration configuration = this.getAuditService().getEntityBindings().get(entityName);
        RelationDescription rd = configuration.getRelationDescription(propertyName = this.sanitizeReferencingPropertyName(referencingPropertyName));
        if (rd == null && configuration.getParentEntityName() != null) {
            return this.searchForRelationDescription(configuration.getParentEntityName(), propertyName);
        }
        return rd;
    }

    private String sanitizeReferencingPropertyName(String propertyName) {
        if (propertyName != null && propertyName.indexOf(46) != -1) {
            return propertyName.replaceAll("\\.", "\\_");
        }
        return propertyName;
    }

    private void generateFakeBidirecationalRelationWorkUnits(AuditProcess auditProcess, PersistentCollection newColl, Serializable oldColl, String collectionEntityName, String referencingPropertyName, AbstractCollectionEvent event, RelationDescription rd) {
        List<PersistentCollectionChangeData> collectionChanges = this.getAuditService().getEntityBindings().get(collectionEntityName).getPropertyMapper().mapCollectionChanges(event.getSession(), referencingPropertyName, newColl, oldColl, event.getAffectedOwnerIdOrNull());
        String relatedEntityName = rd.getToEntityName();
        IdMapper relatedIdMapper = this.getAuditService().getEntityBindings().get(relatedEntityName).getIdMapper();
        for (PersistentCollectionChangeData changeData : collectionChanges) {
            Object relatedObj = changeData.getChangedElement();
            Serializable relatedId = (Serializable)relatedIdMapper.mapToIdFromEntity(relatedObj);
            RevisionType revType = (RevisionType)((Object)changeData.getData().get(this.getAuditService().getOptions().getRevisionTypePropName()));
            String realRelatedEntityName = event.getSession().bestGuessEntityName(relatedObj);
            CollectionChangeWorkUnit nestedWorkUnit = new CollectionChangeWorkUnit(event.getSession(), realRelatedEntityName, rd.getMappedByPropertyName(), this.getAuditService(), relatedId, relatedObj);
            auditProcess.addWorkUnit(new FakeBidirectionalRelationWorkUnit(event.getSession(), realRelatedEntityName, this.getAuditService(), relatedId, referencingPropertyName, event.getAffectedOwnerOrNull(), rd, revType, changeData.getChangedElementIndex(), nestedWorkUnit));
        }
        auditProcess.addWorkUnit(new CollectionChangeWorkUnit(event.getSession(), collectionEntityName, referencingPropertyName, this.getAuditService(), event.getAffectedOwnerIdOrNull(), event.getAffectedOwnerOrNull()));
    }

    private void generateBidirectionalCollectionChangeWorkUnits(AuditProcess auditProcess, AbstractCollectionEvent event, PersistentCollectionChangeWorkUnit workUnit, RelationDescription rd) {
        if (!this.getAuditService().getOptions().isRevisionOnCollectionChangeEnabled()) {
            return;
        }
        if (rd != null && rd.isBidirectional()) {
            String relatedEntityName = rd.getToEntityName();
            IdMapper relatedIdMapper = this.getAuditService().getEntityBindings().get(relatedEntityName).getIdMapper();
            Set<String> toPropertyNames = this.getAuditService().getEntityBindings().getToPropertyNames(event.getAffectedOwnerEntityName(), rd.getFromPropertyName(), relatedEntityName);
            String toPropertyName = toPropertyNames.iterator().next();
            for (PersistentCollectionChangeData changeData : workUnit.getCollectionChanges()) {
                Object relatedObj = changeData.getChangedElement();
                Serializable relatedId = (Serializable)relatedIdMapper.mapToIdFromEntity(relatedObj);
                auditProcess.addWorkUnit(new CollectionChangeWorkUnit(event.getSession(), event.getSession().bestGuessEntityName(relatedObj), toPropertyName, this.getAuditService(), relatedId, relatedObj));
            }
        }
    }

    private String resolveReferencingPropertyName(String entityName, CollectionEntry collectionEntry) {
        return collectionEntry.getNavigableRole().getFullPath().substring(entityName.length() + 1);
    }

    private boolean isInverse(CollectionEntry collectionEntry) {
        return collectionEntry.getLoadedCollectionDescriptor().isInverse();
    }

    private boolean isOneToMany(CollectionEntry collectionEntry) {
        return collectionEntry.getLoadedCollectionDescriptor().getElementDescriptor().getClassification().equals((Object)CollectionElement.ElementClassification.ONE_TO_MANY);
    }
}

