/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event.spi;

import java.io.Serializable;
import java.util.Set;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.event.spi.EnversListener;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.entities.RelationType;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.envers.internal.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.internal.tools.EntityTools;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.proxy.HibernateProxy;

public abstract class AbstractEnversEventListener
implements EnversListener {
    private final AuditService auditService;

    protected AbstractEnversEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    protected AuditService getAuditService() {
        return this.auditService;
    }

    protected final void generateBidirectionalCollectionChangeWorkUnits(AuditProcess auditProcess, EntityTypeDescriptor entityDescriptor, String entityName, Object[] newState, Object[] oldState, SessionImplementor session) {
        if (!this.auditService.getOptions().isRevisionOnCollectionChangeEnabled()) {
            return;
        }
        String[] propertyNames = EntityTools.getPropertyNames(entityDescriptor);
        for (int i = 0; i < propertyNames.length; ++i) {
            Object newValue;
            String propertyName = propertyNames[i];
            RelationDescription relDesc = this.auditService.getEntityBindings().getRelationDescription(entityName, propertyName);
            if (relDesc == null || !relDesc.isBidirectional() || relDesc.getRelationType() != RelationType.TO_ONE || !relDesc.isInsertable()) continue;
            Object oldValue = oldState == null ? null : oldState[i];
            Object object = newValue = newState == null ? null : newState[i];
            if (EntityTools.entitiesEqual(session, relDesc.getToEntityName(), oldValue, newValue)) continue;
            if (newValue != null) {
                this.addCollectionChangeWorkUnit(auditProcess, session, entityName, relDesc, newValue);
            }
            if (oldValue == null) continue;
            this.addCollectionChangeWorkUnit(auditProcess, session, entityName, relDesc, oldValue);
        }
    }

    private void addCollectionChangeWorkUnit(AuditProcess auditProcess, SessionImplementor session, String fromEntityName, RelationDescription relDesc, Object value) {
        String toEntityName;
        Object id;
        if (value instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)value;
            id = hibernateProxy.getHibernateLazyInitializer().getIdentifier();
            value = EntityTools.getTargetFromProxy(session.getFactory(), hibernateProxy);
            toEntityName = session.bestGuessEntityName(value);
        } else {
            toEntityName = session.guessEntityName(value);
            IdMapper idMapper = this.auditService.getEntityBindings().get(toEntityName).getIdMapper();
            id = (Serializable)idMapper.mapToIdFromEntity(value);
        }
        Set<String> toPropertyNames = this.auditService.getEntityBindings().getToPropertyNames(fromEntityName, relDesc.getFromPropertyName(), toEntityName);
        String toPropertyName = toPropertyNames.iterator().next();
        auditProcess.addWorkUnit(new CollectionChangeWorkUnit(session, toEntityName, toPropertyName, this.auditService, id, value));
    }

    protected void checkIfTransactionInProgress(SessionImplementor session) {
        if (!session.isTransactionInProgress()) {
            throw new AuditException("Unable to create revision because of non-active transaction");
        }
    }
}

