/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities;

import java.util.Map;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.ToOneDelegateSessionImplementor;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.metamodel.spi.EntityInstantiator;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class EntityInstantiatorImpl
implements EntityInstantiator {
    private final AuditReaderImplementor versionsReader;

    public EntityInstantiatorImpl(AuditReaderImplementor versionsReader) {
        this.versionsReader = versionsReader;
    }

    public Object createInstanceFromVersionsEntity(String entityName, Map versionsEntity, Number revision) {
        Object ret;
        if (versionsEntity == null) {
            return null;
        }
        String type = this.getAuditService().getEntityBindings().getEntityNameForVersionsEntityName((String)versionsEntity.get("$type$"));
        if (type != null) {
            entityName = type;
        }
        IdMapper idMapper = this.getAuditService().getEntityBindings().get(entityName).getIdMapper();
        Map originalId = (Map)versionsEntity.get(this.getAuditService().getOptions().getOriginalIdPropName());
        this.replaceNonAuditIdProxies(versionsEntity, revision);
        Object primaryKey = idMapper.mapToIdFromMap(originalId);
        if (this.versionsReader.getFirstLevelCache().contains(entityName, revision, primaryKey)) {
            return this.versionsReader.getFirstLevelCache().get(entityName, revision, primaryKey);
        }
        try {
            EntityConfiguration entCfg = this.getAuditService().getEntityBindings().get(entityName);
            if (entCfg == null) {
                entCfg = this.getAuditService().getEntityBindings().getNotVersionEntityConfiguration(entityName);
            }
            Class cls = ReflectionTools.loadClass(entCfg.getEntityClassName(), this.getAuditService().getClassLoaderService());
            ret = ReflectHelper.getDefaultConstructor(cls).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
        this.versionsReader.getFirstLevelCache().put(entityName, revision, primaryKey, ret);
        this.getAuditService().getEntityBindings().get(entityName).getPropertyMapper().mapToEntityFromMap(ret, versionsEntity, primaryKey, this.versionsReader, revision);
        idMapper.mapToEntityFromMap(ret, originalId);
        this.versionsReader.getFirstLevelCache().putOnEntityNameCache(primaryKey, revision, ret, entityName);
        return ret;
    }

    private void replaceNonAuditIdProxies(Map versionsEntity, Number revision) {
        Map originalId = (Map)versionsEntity.get(this.getAuditService().getOptions().getOriginalIdPropName());
        for (Object key : originalId.keySet()) {
            Object value = originalId.get(key);
            if (!(value instanceof HibernateProxy)) continue;
            HibernateProxy hibernateProxy = (HibernateProxy)value;
            LazyInitializer initializer = hibernateProxy.getHibernateLazyInitializer();
            String entityName = initializer.getEntityName();
            Object entityId = initializer.getIdentifier();
            if (!this.getAuditService().getEntityBindings().isVersioned(entityName)) continue;
            String entityClassName = this.getAuditService().getEntityBindings().get(entityName).getEntityClassName();
            Class entityClass = ReflectionTools.loadClass(entityClassName, this.getAuditService().getClassLoaderService());
            ToOneDelegateSessionImplementor delegate = new ToOneDelegateSessionImplementor(this.versionsReader, entityClass, entityId, revision, RevisionType.DEL.equals(versionsEntity.get(this.getAuditService().getOptions().getRevisionTypePropName())));
            originalId.put(key, this.versionsReader.getSessionImplementor().getFactory().getMetamodel().findEntityDescriptor(entityName).createProxy(entityId, delegate));
        }
    }

    @Override
    public AuditService getAuditService() {
        return this.getAuditReaderImplementor().getAuditService();
    }

    @Override
    public AuditReaderImplementor getAuditReaderImplementor() {
        return this.versionsReader;
    }
}

