/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities;

import java.util.Objects;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class PropertyData {
    private final String name;
    private final String beanName;
    private final String accessType;
    private final boolean usingModifiedFlag;
    private final String modifiedFlagName;
    private boolean synthetic;
    private Class<?> virtualReturnClass;
    private JavaTypeDescriptor javaTypeDescriptor;

    public PropertyData(String newName, PropertyData propertyData) {
        this(newName, propertyData.beanName, propertyData.accessType, propertyData.getJavaTypeDescriptor());
    }

    public PropertyData(String name, String beanName, String accessType) {
        this(name, beanName, accessType, null);
    }

    public PropertyData(String name, String beanName, String accessType, JavaTypeDescriptor javaTypeDescriptor) {
        this(name, beanName, accessType, false, null, false, javaTypeDescriptor, null);
    }

    public PropertyData(String name, String beanName, String accessType, boolean usingModifiedFlag, String modifiedFlagName, boolean synthetic) {
        this(name, beanName, accessType, usingModifiedFlag, modifiedFlagName, synthetic, null, null);
    }

    public PropertyData(String name, String beanName, String accessType, boolean usingModifiedFlag, String modifiedFlagName, boolean synthetic, JavaTypeDescriptor javaTypeDescriptor) {
        this(name, beanName, accessType, usingModifiedFlag, modifiedFlagName, synthetic, javaTypeDescriptor, null);
    }

    public PropertyData(String name, String beanName, String accessType, boolean usingModifiedFlag, String modifiedFlagName, boolean synthetic, JavaTypeDescriptor javaTypeDescriptor, Class<?> virtualReturnClass) {
        this.name = name;
        this.beanName = beanName;
        this.accessType = accessType;
        this.usingModifiedFlag = usingModifiedFlag;
        this.modifiedFlagName = modifiedFlagName;
        this.synthetic = synthetic;
        this.javaTypeDescriptor = javaTypeDescriptor;
        this.virtualReturnClass = virtualReturnClass;
    }

    public String getName() {
        return this.name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public boolean isUsingModifiedFlag() {
        return this.usingModifiedFlag;
    }

    public String getModifiedFlagPropertyName() {
        return this.modifiedFlagName;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    public Class<?> getVirtualReturnClass() {
        return this.virtualReturnClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyData that = (PropertyData)o;
        return this.usingModifiedFlag == that.usingModifiedFlag && Objects.equals(this.accessType, that.accessType) && Objects.equals(this.beanName, that.beanName) && Objects.equals(this.name, that.name) && Objects.equals(this.synthetic, that.synthetic);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.beanName != null ? this.beanName.hashCode() : 0);
        result = 31 * result + (this.accessType != null ? this.accessType.hashCode() : 0);
        result = 31 * result + (this.usingModifiedFlag ? 1 : 0);
        result = 31 * result + (this.synthetic ? 1 : 0);
        return result;
    }

    public static PropertyData forProperty(String propertyName, JavaTypeDescriptor javaTypeDescriptor) {
        return new PropertyData(propertyName, null, null, javaTypeDescriptor);
    }
}

