/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities;

import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.type.descriptor.java.internal.LocalDateJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.TemporalJavaDescriptor;

public class RevisionTimestampData
extends PropertyData {
    private JavaTypeDescriptor javaTypeDescriptor;

    public RevisionTimestampData(String name, String beanName, String accessType, JavaTypeDescriptor javaTypeDescriptor) {
        super(name, beanName, accessType, null);
        this.javaTypeDescriptor = javaTypeDescriptor;
    }

    public RevisionTimestampData(RevisionTimestampData old, JavaTypeDescriptor javaTypeDescriptor) {
        this(old.getName(), old.getBeanName(), old.getAccessType(), javaTypeDescriptor);
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    public boolean isTimestampDate() {
        assert (this.javaTypeDescriptor != null);
        return TemporalJavaDescriptor.class.isInstance(this.javaTypeDescriptor);
    }

    public boolean isTimestampLocalDateTime() {
        return LocalDateJavaDescriptor.class.isInstance(this.javaTypeDescriptor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.javaTypeDescriptor.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RevisionTimestampData that = (RevisionTimestampData)o;
        return this.javaTypeDescriptor.equals(that.javaTypeDescriptor);
    }
}

