/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.AbstractPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.ComponentPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.ExtendedPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.SinglePropertyMapper;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.MappingTools;
import org.hibernate.envers.internal.tools.Pair;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.property.access.spi.Getter;

public class MultiPropertyMapper
extends AbstractPropertyMapper
implements ExtendedPropertyMapper {
    protected final Map<PropertyData, PropertyMapper> properties = new HashMap<PropertyData, PropertyMapper>();
    private final Map<String, PropertyData> propertyDatas = new HashMap<String, PropertyData>();

    @Override
    public void add(PropertyData propertyData) {
        SinglePropertyMapper single = new SinglePropertyMapper();
        single.add(propertyData);
        this.properties.put(propertyData, single);
        this.propertyDatas.put(propertyData.getName(), propertyData);
    }

    @Override
    public CompositeMapperBuilder addComponent(PropertyData propertyData, Class componentClass) {
        if (this.properties.get(propertyData) != null) {
            return (CompositeMapperBuilder)((Object)this.properties.get(propertyData));
        }
        ComponentPropertyMapper componentMapperBuilder = new ComponentPropertyMapper(propertyData, componentClass);
        this.addComposite(propertyData, componentMapperBuilder);
        return componentMapperBuilder;
    }

    @Override
    public void addComposite(PropertyData propertyData, PropertyMapper propertyMapper) {
        this.properties.put(propertyData, propertyMapper);
        this.propertyDatas.put(propertyData.getName(), propertyData);
    }

    protected Object getAtIndexOrNull(Object[] array, int index) {
        return array == null ? null : array[index];
    }

    @Override
    public boolean map(SessionImplementor session, Map<String, Object> data, String[] propertyNames, Object[] newState, Object[] oldState) {
        boolean ret = false;
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (!this.propertyDatas.containsKey(propertyName)) continue;
            PropertyMapper propertyMapper = this.properties.get(this.propertyDatas.get(propertyName));
            Object newObj = this.getAtIndexOrNull(newState, i);
            Object oldObj = this.getAtIndexOrNull(oldState, i);
            ret |= propertyMapper.mapToMapFromEntity(session, data, newObj, oldObj);
            propertyMapper.mapModifiedFlagsToMapFromEntity(session, data, newObj, oldObj);
        }
        return ret;
    }

    @Override
    public boolean mapToMapFromEntity(final SessionImplementor session, final Map<String, Object> data, final Object newObj, final Object oldObj) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean ret = false;
                for (Map.Entry<PropertyData, PropertyMapper> entry : MultiPropertyMapper.this.properties.entrySet()) {
                    Getter getter;
                    PropertyData propertyData = entry.getKey();
                    PropertyMapper propertyMapper = entry.getValue();
                    if (propertyData.isSynthetic()) continue;
                    if (newObj != null) {
                        getter = ReflectionTools.getGetter(newObj.getClass(), propertyData, session.getFactory().getServiceRegistry());
                    } else if (oldObj != null) {
                        getter = ReflectionTools.getGetter(oldObj.getClass(), propertyData, session.getFactory().getServiceRegistry());
                    } else {
                        return false;
                    }
                    ret |= propertyMapper.mapToMapFromEntity(session, data, newObj == null ? null : getter.get(newObj), oldObj == null ? null : getter.get(oldObj));
                }
                return ret;
            }
        });
    }

    @Override
    public void mapModifiedFlagsToMapFromEntity(final SessionImplementor session, final Map<String, Object> data, final Object newObj, final Object oldObj) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (Map.Entry<PropertyData, PropertyMapper> entry : MultiPropertyMapper.this.properties.entrySet()) {
                    Getter getter;
                    PropertyData propertyData = entry.getKey();
                    PropertyMapper propertyMapper = entry.getValue();
                    if (propertyData.isSynthetic()) continue;
                    if (newObj != null) {
                        getter = ReflectionTools.getGetter(newObj.getClass(), propertyData, session.getFactory().getServiceRegistry());
                    } else {
                        if (oldObj == null) break;
                        getter = ReflectionTools.getGetter(oldObj.getClass(), propertyData, session.getFactory().getServiceRegistry());
                    }
                    propertyMapper.mapModifiedFlagsToMapFromEntity(session, data, newObj == null ? null : getter.get(newObj), oldObj == null ? null : getter.get(oldObj));
                }
                return null;
            }
        });
    }

    @Override
    public void mapToEntityFromMap(Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        for (PropertyMapper mapper : this.properties.values()) {
            mapper.mapToEntityFromMap(obj, data, primaryKey, versionsReader, revision);
        }
    }

    private Pair<PropertyMapper, String> getMapperAndDelegatePropName(String referencingPropertyName) {
        String delegatePropertyName;
        int dotIndex = referencingPropertyName.indexOf(46);
        if (dotIndex != -1) {
            String componentName = referencingPropertyName.substring(0, dotIndex);
            String propertyInComponentName = MappingTools.createComponentPrefix(componentName) + referencingPropertyName.substring(dotIndex + 1);
            referencingPropertyName = componentName;
            delegatePropertyName = propertyInComponentName;
        } else {
            delegatePropertyName = referencingPropertyName;
        }
        return Pair.make(this.properties.get(this.propertyDatas.get(referencingPropertyName)), delegatePropertyName);
    }

    @Override
    public void mapModifiedFlagsToMapForCollectionChange(String collectionPropertyName, Map<String, Object> data) {
        Pair<PropertyMapper, String> pair = this.getMapperAndDelegatePropName(collectionPropertyName);
        PropertyMapper mapper = pair.getFirst();
        if (mapper != null) {
            mapper.mapModifiedFlagsToMapForCollectionChange(pair.getSecond(), data);
        }
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Object id) {
        Pair<PropertyMapper, String> pair = this.getMapperAndDelegatePropName(referencingPropertyName);
        PropertyMapper mapper = pair.getFirst();
        if (mapper != null) {
            return mapper.mapCollectionChanges(session, pair.getSecond(), newColl, oldColl, id);
        }
        return null;
    }

    @Override
    public Map<PropertyData, PropertyMapper> getProperties() {
        return this.properties;
    }

    public Map<String, PropertyData> getPropertyDatas() {
        return this.propertyDatas;
    }

    @Override
    public boolean hasPropertiesWithModifiedFlag() {
        for (PropertyData property : this.getProperties().keySet()) {
            if (!property.isUsingModifiedFlag()) continue;
            return true;
        }
        return false;
    }
}

