/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.AbstractPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.SimpleMapperBuilder;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.property.access.spi.SetterFieldImpl;

public class SinglePropertyMapper
extends AbstractPropertyMapper
implements SimpleMapperBuilder {
    private PropertyData propertyData;

    public SinglePropertyMapper(PropertyData propertyData) {
        this.propertyData = propertyData;
    }

    public SinglePropertyMapper() {
    }

    @Override
    public void add(PropertyData propertyData) {
        if (this.propertyData != null) {
            throw new AuditException("Only one property can be added!");
        }
        this.propertyData = propertyData;
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        data.put(this.propertyData.getName(), newObj);
        if ((newObj instanceof String || oldObj instanceof String) && session.getFactory().getJdbcServices().getDialect().isEmptyStringTreatedAsNull() && StringTools.isEmpty(newObj) && StringTools.isEmpty(oldObj)) {
            return false;
        }
        return !this.areEqual(newObj, oldObj);
    }

    @Override
    public void mapModifiedFlagsToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        if (this.propertyData.isUsingModifiedFlag() && !this.propertyData.isSynthetic()) {
            data.put(this.propertyData.getModifiedFlagPropertyName(), !this.areEqual(newObj, oldObj));
        }
    }

    @Override
    public void mapModifiedFlagsToMapForCollectionChange(String collectionPropertyName, Map<String, Object> data) {
    }

    @Override
    public void mapToEntityFromMap(final Object obj, Map data, Object primaryKey, final AuditReaderImplementor versionsReader, Number revision) {
        if (data == null || obj == null || this.propertyData.isSynthetic()) {
            return;
        }
        final Object value = data.get(this.propertyData.getName());
        if (this.isDynamicComponentMap()) {
            Map map = (Map)obj;
            map.put(this.propertyData.getBeanName(), value);
        } else {
            PrivilegedAction<Object> delegatedAction = new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Setter setter = ReflectionTools.getSetter(obj.getClass(), SinglePropertyMapper.this.propertyData, versionsReader.getSessionImplementor().getSessionFactory().getServiceRegistry());
                    if (value != null || !SinglePropertyMapper.this.isPrimitive(setter, SinglePropertyMapper.this.propertyData, obj.getClass())) {
                        setter.set(obj, value, null);
                    }
                    return null;
                }
            };
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(delegatedAction);
            } else {
                delegatedAction.run();
            }
        }
    }

    private boolean isPrimitive(Setter setter, PropertyData propertyData, Class<?> cls) {
        if (cls == null) {
            throw new HibernateException("No field found for property: " + propertyData.getName());
        }
        if (setter instanceof SetterFieldImpl) {
            try {
                return cls.getDeclaredField(propertyData.getBeanName()).getType().isPrimitive();
            }
            catch (NoSuchFieldException e) {
                return this.isPrimitive(setter, propertyData, cls.getSuperclass());
            }
        }
        return setter.getMethod().getParameterTypes()[0].isPrimitive();
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor sessionImplementor, String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Object id) {
        return null;
    }

    @Override
    public boolean hasPropertiesWithModifiedFlag() {
        return this.propertyData != null && this.propertyData.isUsingModifiedFlag();
    }

    private boolean areEqual(Object newObj, Object oldObj) {
        if (this.propertyData.getJavaTypeDescriptor() != null) {
            return this.propertyData.getJavaTypeDescriptor().areEqual(newObj, oldObj);
        }
        return Objects.equals(newObj, oldObj);
    }
}

