/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.AbstractPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.relation.CommonCollectionMapperData;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.Initializor;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.property.access.spi.Setter;

public abstract class AbstractCollectionMapper<T>
extends AbstractPropertyMapper {
    protected final CommonCollectionMapperData commonCollectionMapperData;
    protected final Class<? extends T> collectionClass;
    protected final boolean ordinalInId;
    protected final boolean revisionTypeInId;
    private final Constructor<? extends T> proxyConstructor;

    protected AbstractCollectionMapper(CommonCollectionMapperData commonCollectionMapperData, Class<? extends T> collectionClass, Class<? extends T> proxyClass, boolean ordinalInId, boolean revisionTypeInId) {
        this.commonCollectionMapperData = commonCollectionMapperData;
        this.collectionClass = collectionClass;
        this.ordinalInId = ordinalInId;
        this.revisionTypeInId = revisionTypeInId;
        try {
            this.proxyConstructor = proxyClass.getConstructor(Initializor.class);
        }
        catch (NoSuchMethodException e) {
            throw new AuditException(e);
        }
    }

    protected abstract Collection getNewCollectionContent(PersistentCollection var1);

    protected abstract Collection getOldCollectionContent(Serializable var1);

    protected abstract Set<Object> buildCollectionChangeSet(Object var1, Collection var2);

    protected abstract void mapToMapFromObject(SessionImplementor var1, Map<String, Object> var2, Map<String, Object> var3, Object var4);

    protected Map<String, Object> createIdMap(int ordinal) {
        HashMap<String, Object> idMap = new HashMap<String, Object>();
        if (this.ordinalInId) {
            idMap.put(this.commonCollectionMapperData.getOptions().getEmbeddableSetOrdinalPropertyName(), ordinal);
        }
        return idMap;
    }

    protected void addCollectionChanges(SessionImplementor session, List<PersistentCollectionChangeData> collectionChanges, Set<Object> changed, RevisionType revisionType, Object id) {
        int ordinal = 0;
        for (Object changedObj : changed) {
            HashMap<String, Object> entityData = new HashMap<String, Object>();
            Map<String, Object> originalId = this.createIdMap(ordinal++);
            entityData.put(this.commonCollectionMapperData.getOptions().getOriginalIdPropName(), originalId);
            collectionChanges.add(new PersistentCollectionChangeData(this.commonCollectionMapperData.getVersionsMiddleEntityName(), entityData, changedObj));
            this.commonCollectionMapperData.getReferencingIdData().getPrefixedMapper().mapToMapFromId(originalId, id);
            this.mapToMapFromObject(session, originalId, entityData, changedObj);
            (this.revisionTypeInId ? originalId : entityData).put(this.commonCollectionMapperData.getOptions().getRevisionTypePropName(), (Object)revisionType);
        }
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Object id) {
        PropertyData collectionPropertyData = this.commonCollectionMapperData.getCollectionReferencingPropertyData();
        if (!collectionPropertyData.getName().equals(referencingPropertyName)) {
            return null;
        }
        return this.mapCollectionChanges(session, newColl, oldColl, id);
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        return false;
    }

    @Override
    public void mapModifiedFlagsToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        PropertyData propertyData = this.commonCollectionMapperData.getCollectionReferencingPropertyData();
        if (propertyData.isUsingModifiedFlag()) {
            if (this.isNotPersistentCollection(newObj) || this.isNotPersistentCollection(oldObj)) {
                data.put(propertyData.getModifiedFlagPropertyName(), !Objects.equals(newObj, oldObj));
            } else if (this.isFromNullToEmptyOrFromEmptyToNull((PersistentCollection)newObj, (Serializable)oldObj)) {
                data.put(propertyData.getModifiedFlagPropertyName(), true);
            } else {
                PersistentCollection pc = (PersistentCollection)newObj;
                if (pc != null && !pc.isDirty() || newObj == null && oldObj == null) {
                    data.put(propertyData.getModifiedFlagPropertyName(), false);
                    return;
                }
                List<PersistentCollectionChangeData> changes = this.mapCollectionChanges(session, this.commonCollectionMapperData.getCollectionReferencingPropertyData().getName(), (PersistentCollection)newObj, (Serializable)oldObj, null);
                data.put(propertyData.getModifiedFlagPropertyName(), !changes.isEmpty());
            }
        }
    }

    private boolean isNotPersistentCollection(Object obj) {
        return obj != null && !(obj instanceof PersistentCollection);
    }

    private boolean isFromNullToEmptyOrFromEmptyToNull(PersistentCollection newColl, Serializable oldColl) {
        Collection newCollection = this.getNewCollectionContent(newColl);
        Collection oldCollection = this.getOldCollectionContent(oldColl);
        return oldCollection == null && newCollection != null && newCollection.isEmpty() || newCollection == null && oldCollection != null && oldCollection.isEmpty();
    }

    @Override
    public void mapModifiedFlagsToMapForCollectionChange(String collectionPropertyName, Map<String, Object> data) {
        PropertyData propertyData = this.commonCollectionMapperData.getCollectionReferencingPropertyData();
        if (propertyData.isUsingModifiedFlag()) {
            data.put(propertyData.getModifiedFlagPropertyName(), propertyData.getName().equals(collectionPropertyName));
        }
    }

    protected abstract Initializor<T> getInitializor(AuditReaderImplementor var1, Object var2, Number var3, boolean var4);

    protected PersistentCollectionDescriptor resolveCollectionDescriptor(SessionImplementor session, PersistentCollection collection) {
        PersistentCollectionDescriptor descriptor;
        CollectionEntry collectionEntry;
        if (collection != null && (collectionEntry = session.getPersistenceContext().getCollectionEntry(collection)) != null && (descriptor = collectionEntry.getCurrentDescriptor()) != null) {
            return descriptor;
        }
        PersistentCollectionDescriptor descriptor2 = session.getFactory().getMetamodel().getCollectionDescriptor(this.commonCollectionMapperData.getRole());
        if (descriptor2 == null) {
            throw new AuditException(String.format(Locale.ROOT, "Failed to locate PersistentCollectionDescriptor for collection [%s].", this.commonCollectionMapperData.getRole()));
        }
        return descriptor2;
    }

    protected boolean isSame(PersistentCollectionDescriptor collectionDescriptor, Object oldObject, Object newObject, SessionImplementor session) {
        return !collectionDescriptor.getElementDescriptor().isDirty(oldObject, newObject, session);
    }

    @Override
    public void mapToEntityFromMap(final Object obj, Map data, Object primaryKey, final AuditReaderImplementor versionsReader, Number revision) {
        T collectionProxy;
        String revisionTypePropertyName = versionsReader.getAuditService().getOptions().getRevisionTypePropName();
        try {
            collectionProxy = this.proxyConstructor.newInstance(this.getInitializor(versionsReader, primaryKey, revision, RevisionType.DEL.equals(data.get(revisionTypePropertyName))));
        }
        catch (Exception e) {
            throw new AuditException("Failed to construct collection proxy", e);
        }
        final PropertyData collectionPropertyData = this.commonCollectionMapperData.getCollectionReferencingPropertyData();
        if (this.isDynamicComponentMap()) {
            Map map = (Map)obj;
            map.put(collectionPropertyData.getBeanName(), collectionProxy);
        } else {
            PrivilegedAction<Object> delegatedAction = new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Setter setter = ReflectionTools.getSetter(obj.getClass(), collectionPropertyData, versionsReader.getSessionImplementor().getSessionFactory().getServiceRegistry());
                    setter.set(obj, collectionProxy, null);
                    return null;
                }
            };
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(delegatedAction);
            } else {
                delegatedAction.run();
            }
        }
    }

    protected abstract List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor var1, PersistentCollection var2, Serializable var3, Object var4);

    @Override
    public boolean hasPropertiesWithModifiedFlag() {
        if (this.commonCollectionMapperData != null) {
            PropertyData propertyData = this.commonCollectionMapperData.getCollectionReferencingPropertyData();
            return propertyData != null && propertyData.isUsingModifiedFlag();
        }
        return false;
    }
}

