/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.AbstractPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.service.ServiceRegistry;

public abstract class AbstractToOneMapper
extends AbstractPropertyMapper {
    private final ServiceRegistry serviceRegistry;
    private final PropertyData propertyData;

    protected AbstractToOneMapper(ServiceRegistry serviceRegistry, PropertyData propertyData) {
        this.serviceRegistry = serviceRegistry;
        this.propertyData = propertyData;
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        return false;
    }

    @Override
    public void mapToEntityFromMap(Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        if (obj != null) {
            this.nullSafeMapToEntityFromMap(obj, data, primaryKey, versionsReader, revision);
        }
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Object id) {
        return null;
    }

    protected EntityInfo getEntityInfo(AuditReaderImplementor versionsReader, String entityName) {
        AuditService auditService = versionsReader.getAuditService();
        EntityConfiguration entCfg = auditService.getEntityBindings().get(entityName);
        boolean isRelationAudited = true;
        if (entCfg == null) {
            entCfg = auditService.getEntityBindings().getNotVersionEntityConfiguration(entityName);
            isRelationAudited = false;
        }
        Class entityClass = ReflectionTools.loadClass(entCfg.getEntityClassName(), auditService.getClassLoaderService());
        return new EntityInfo(entityClass, entityName, isRelationAudited);
    }

    protected void setPropertyValue(final Object targetObject, final Object value) {
        if (this.isDynamicComponentMap()) {
            Map map = (Map)targetObject;
            map.put(this.propertyData.getBeanName(), value);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Setter setter = ReflectionTools.getSetter(targetObject.getClass(), AbstractToOneMapper.this.propertyData, AbstractToOneMapper.this.serviceRegistry);
                    setter.set(targetObject, value, null);
                    return null;
                }
            });
        }
    }

    protected PropertyData getPropertyData() {
        return this.propertyData;
    }

    @Override
    public boolean hasPropertiesWithModifiedFlag() {
        return this.propertyData != null && this.propertyData.isUsingModifiedFlag();
    }

    public abstract void nullSafeMapToEntityFromMap(Object var1, Map var2, Object var3, AuditReaderImplementor var4, Number var5);

    protected static class EntityInfo {
        private final Class entityClass;
        private final String entityName;
        private final boolean audited;

        public EntityInfo(Class entityClass, String entityName, boolean audited) {
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.audited = audited;
        }

        public Class getEntityClass() {
            return this.entityClass;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public boolean isAudited() {
            return this.audited;
        }
    }
}

