/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Type;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.relation.AbstractCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.CommonCollectionMapperData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.BasicCollectionInitializor;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.Initializor;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.metamodel.model.domain.CollectionDomainType;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public class BasicCollectionMapper<T extends Collection>
extends AbstractCollectionMapper<T>
implements PropertyMapper {
    protected final MiddleComponentData elementComponentData;

    public BasicCollectionMapper(CommonCollectionMapperData commonCollectionMapperData, Class<? extends T> collectionClass, Class<? extends T> proxyClass, MiddleComponentData elementComponentData, boolean ordinalInId, boolean revisionTypeInId) {
        super(commonCollectionMapperData, collectionClass, proxyClass, ordinalInId, revisionTypeInId);
        this.elementComponentData = elementComponentData;
    }

    @Override
    protected Initializor<T> getInitializor(AuditReaderImplementor versionsReader, Object primaryKey, Number revision, boolean removed) {
        return new BasicCollectionInitializor(versionsReader, this.commonCollectionMapperData.getQueryGenerator(), primaryKey, revision, removed, this.collectionClass, this.elementComponentData);
    }

    @Override
    protected Collection getNewCollectionContent(PersistentCollection newCollection) {
        return (Collection)((Object)newCollection);
    }

    @Override
    protected Collection getOldCollectionContent(Serializable oldCollection) {
        if (oldCollection == null) {
            return null;
        }
        if (oldCollection instanceof Map) {
            return ((Map)((Object)oldCollection)).keySet();
        }
        return (Collection)((Object)oldCollection);
    }

    @Override
    protected void mapToMapFromObject(SessionImplementor session, Map<String, Object> idData, Map<String, Object> data, Object changed) {
        this.elementComponentData.getComponentMapper().mapToMapFromObject(session, idData, data, changed);
    }

    @Override
    protected Set<Object> buildCollectionChangeSet(Object eventCollection, Collection collection) {
        HashSet<Object> changeSet = new HashSet<Object>();
        if (eventCollection != null) {
            for (Object entry : collection) {
                if (entry == null) continue;
                changeSet.add(entry);
            }
        }
        return changeSet;
    }

    @Override
    protected List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, PersistentCollection newColl, Serializable oldColl, Object id) {
        ArrayList<PersistentCollectionChangeData> collectionChanges = new ArrayList<PersistentCollectionChangeData>();
        PersistentCollectionDescriptor collectionDescriptor = this.resolveCollectionDescriptor(session, newColl);
        Collection newCollection = this.getNewCollectionContent(newColl);
        Collection oldCollection = this.getOldCollectionContent(oldColl);
        Set<Object> addedElements = this.buildCollectionChangeSet(newColl, newCollection);
        if (oldColl != null) {
            block0: for (Object oldEntry : oldCollection) {
                Iterator<Object> itor = addedElements.iterator();
                while (itor.hasNext()) {
                    Object newEntry = itor.next();
                    if (!this.isCollectionElementSame(session, collectionDescriptor, oldEntry, newEntry)) continue;
                    itor.remove();
                    continue block0;
                }
            }
        }
        Set<Object> deleteElements = this.buildCollectionChangeSet(oldColl, oldCollection);
        if (newColl != null) {
            block2: for (Object newEntry : newCollection) {
                Iterator<Object> itor = deleteElements.iterator();
                while (itor.hasNext()) {
                    Object deletedEntry = itor.next();
                    if (!this.isCollectionElementSame(session, collectionDescriptor, deletedEntry, newEntry)) continue;
                    itor.remove();
                    continue block2;
                }
            }
        }
        this.addCollectionChanges(session, collectionChanges, addedElements, RevisionType.ADD, id);
        this.addCollectionChanges(session, collectionChanges, deleteElements, RevisionType.DEL, id);
        return collectionChanges;
    }

    private boolean isCollectionElementSame(SessionImplementor session, PersistentCollectionDescriptor collectionDescriptor, Object lhs, Object rhs) {
        CollectionDomainType.Element element = collectionDescriptor.getElementDescriptor();
        if (Type.PersistenceType.ENTITY.equals((Object)element.getPersistenceType()) && !this.revisionTypeInId) {
            if (this.isSame(collectionDescriptor, lhs, rhs, session)) {
                return true;
            }
            EntityTypeDescriptor entityDescriptor = session.getFactory().getMetamodel().findEntityDescriptor(element.getJavaType());
            Object lhsId = entityDescriptor.getIdentifier(lhs);
            Object rhsId = entityDescriptor.getIdentifier(rhs);
            return entityDescriptor.getIdentifierDescriptor().getJavaTypeDescriptor().areEqual(lhsId, rhsId);
        }
        return this.isSame(collectionDescriptor, lhs, rhs, session);
    }
}

