/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;

public final class MiddleIdData {
    private final IdMapper originalMapper;
    private final IdMapper prefixedMapper;
    private final String entityName;
    private final String auditEntityName;

    public MiddleIdData(IdMappingData mappingData, String prefix, String entityName) {
        this(mappingData, prefix, entityName, null);
    }

    public MiddleIdData(IdMappingData mappingData, String prefix, String entityName, String auditEntityName) {
        this.originalMapper = mappingData.getIdMapper();
        this.prefixedMapper = mappingData.getIdMapper().prefixMappedProperties(prefix);
        this.entityName = entityName;
        this.auditEntityName = auditEntityName;
    }

    public IdMapper getOriginalMapper() {
        return this.originalMapper;
    }

    public IdMapper getPrefixedMapper() {
        return this.prefixedMapper;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getAuditEntityName() {
        return this.auditEntityName;
    }

    public boolean isAudited() {
        return this.auditEntityName != null;
    }
}

