/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.relation.AbstractOneToOneMapper;
import org.hibernate.envers.internal.entities.mapper.relation.AbstractToOneMapper;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.service.ServiceRegistry;

public class OneToOnePrimaryKeyJoinColumnMapper
extends AbstractOneToOneMapper {
    public OneToOnePrimaryKeyJoinColumnMapper(String entityName, String referencedEntityName, PropertyData propertyData, ServiceRegistry serviceRegistry) {
        super(entityName, referencedEntityName, propertyData, serviceRegistry);
    }

    @Override
    protected Object queryForReferencedEntity(AuditReaderImplementor versionsReader, AbstractToOneMapper.EntityInfo referencedEntity, Object primaryKey, Number revision) {
        if (referencedEntity.isAudited()) {
            return versionsReader.createQuery().forEntitiesAtRevision(referencedEntity.getEntityClass(), referencedEntity.getEntityName(), revision).add(AuditEntity.id().eq(primaryKey)).getSingleResult();
        }
        return this.createNotAuditedEntityReference(versionsReader, referencedEntity.getEntityClass(), referencedEntity.getEntityName(), primaryKey);
    }

    private Object createNotAuditedEntityReference(AuditReaderImplementor versionsReader, Class<?> entityClass, String entityName, Object primaryKey) {
        EntityTypeDescriptor entityDescriptor = versionsReader.getSessionImplementor().getFactory().getMetamodel().findEntityDescriptor(entityName);
        if (entityDescriptor.hasProxy()) {
            return versionsReader.getSession().load(entityClass, primaryKey);
        }
        return versionsReader.getSession().get(entityClass, primaryKey);
    }
}

