/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.ToOneDelegateSessionImplementor;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;

public final class ToOneEntityLoader {
    private ToOneEntityLoader() {
    }

    public static Object loadImmediate(AuditReaderImplementor versionsReader, Class<?> entityClass, String entityName, Object entityId, Number revision, boolean removed) {
        AuditService auditService = versionsReader.getAuditService();
        if (auditService.getEntityBindings().getNotVersionEntityConfiguration(entityName) == null) {
            return versionsReader.find(entityClass, entityName, entityId, revision, removed);
        }
        return versionsReader.getSessionImplementor().immediateLoad(entityName, entityId);
    }

    public static Object createProxy(AuditReaderImplementor versionsReader, Class<?> entityClass, String entityName, Object entityId, Number revision, boolean removed) {
        EntityTypeDescriptor entityDescriptor = ToOneEntityLoader.resolveEntityDescriptorByName(versionsReader, entityName);
        return entityDescriptor.createProxy(entityId, new ToOneDelegateSessionImplementor(versionsReader, entityClass, entityId, revision, removed));
    }

    public static Object createProxyOrLoadImmediate(AuditReaderImplementor versionsReader, Class<?> entityClass, String entityName, Object entityId, Number revision, boolean removed) {
        EntityTypeDescriptor entityDescriptor = ToOneEntityLoader.resolveEntityDescriptorByName(versionsReader, entityName);
        if (entityDescriptor.hasProxy()) {
            return ToOneEntityLoader.createProxy(versionsReader, entityClass, entityName, entityId, revision, removed);
        }
        return ToOneEntityLoader.loadImmediate(versionsReader, entityClass, entityName, entityId, revision, removed);
    }

    private static EntityTypeDescriptor resolveEntityDescriptorByName(AuditReaderImplementor versionsReader, String entityName) {
        return versionsReader.getSessionImplementor().getFactory().getMetamodel().findEntityDescriptor(entityName);
    }
}

