/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor;

import java.util.List;
import java.util.Map;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.AbstractCollectionInitializor;
import org.hibernate.envers.internal.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;

public class ArrayCollectionInitializor
extends AbstractCollectionInitializor<Object[]> {
    private final MiddleComponentData elementComponentData;
    private final MiddleComponentData indexComponentData;

    public ArrayCollectionInitializor(AuditReaderImplementor versionsReader, RelationQueryGenerator queryGenerator, Object primaryKey, Number revision, boolean removed, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        super(versionsReader, queryGenerator, primaryKey, revision, removed);
        this.elementComponentData = elementComponentData;
        this.indexComponentData = indexComponentData;
    }

    @Override
    protected Object[] initializeCollection(int size) {
        return new Object[size];
    }

    @Override
    protected void addToCollection(Object[] collection, Object collectionRow) {
        Object elementData = ((List)collectionRow).get(this.elementComponentData.getComponentIndex());
        Object element = this.elementComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)elementData, null, this.revision);
        Object indexData = ((List)collectionRow).get(this.indexComponentData.getComponentIndex());
        Object indexObj = this.indexComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)indexData, element, this.revision);
        int index = ((Number)indexObj).intValue();
        collection[index] = element;
    }
}

