/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.AbstractCollectionInitializor;
import org.hibernate.envers.internal.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;

public class ListCollectionInitializor
extends AbstractCollectionInitializor<List> {
    private final MiddleComponentData elementComponentData;
    private final MiddleComponentData indexComponentData;

    public ListCollectionInitializor(AuditReaderImplementor versionsReader, RelationQueryGenerator queryGenerator, Object primaryKey, Number revision, boolean removed, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        super(versionsReader, queryGenerator, primaryKey, revision, removed);
        this.elementComponentData = elementComponentData;
        this.indexComponentData = indexComponentData;
    }

    @Override
    protected List initializeCollection(int size) {
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(null);
        }
        return list;
    }

    @Override
    protected void addToCollection(List collection, Object collectionRow) {
        Object elementData = collectionRow;
        Object indexData = collectionRow;
        if (List.class.isInstance(collectionRow)) {
            List row = (List)List.class.cast(collectionRow);
            elementData = row.get(this.elementComponentData.getComponentIndex());
            indexData = row.get(this.indexComponentData.getComponentIndex());
        }
        Object element = Map.class.isInstance(elementData) ? this.elementComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)elementData, null, this.revision) : elementData;
        Object indexObj = this.indexComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)indexData, element, this.revision);
        int index = ((Number)indexObj).intValue();
        for (int i = collection.size(); i <= index; ++i) {
            collection.add(i, null);
        }
        collection.set(index, element);
    }
}

