/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor;

import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.SortedMap;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.MapCollectionInitializor;
import org.hibernate.envers.internal.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;

public class SortedMapCollectionInitializor
extends MapCollectionInitializor<SortedMap> {
    private final Comparator comparator;

    public SortedMapCollectionInitializor(AuditReaderImplementor versionsReader, RelationQueryGenerator queryGenerator, Object primaryKey, Number revision, boolean removed, Class<? extends SortedMap> collectionClass, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData, Comparator comparator) {
        super(versionsReader, queryGenerator, primaryKey, revision, removed, collectionClass, elementComponentData, indexComponentData);
        this.comparator = comparator;
    }

    @Override
    protected SortedMap initializeCollection(int size) {
        if (this.comparator == null) {
            return (SortedMap)super.initializeCollection(size);
        }
        try {
            return (SortedMap)this.collectionClass.getConstructor(Comparator.class).newInstance(this.comparator);
        }
        catch (InstantiationException e) {
            throw new AuditException(e);
        }
        catch (IllegalAccessException e) {
            throw new AuditException(e);
        }
        catch (NoSuchMethodException e) {
            throw new AuditException(e);
        }
        catch (InvocationTargetException e) {
            throw new AuditException(e);
        }
    }
}

