/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.query;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.boot.spi.AuditMetadataBuildingOptions;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.id.MultipleIdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.query.AbstractRelationQueryGenerator;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.internal.util.StringHelper;

public final class OneAuditEntityQueryGenerator
extends AbstractRelationQueryGenerator {
    private final String mappedBy;
    private final boolean multipleIdMapperKey;
    private final MiddleIdData referencedIdData;

    public OneAuditEntityQueryGenerator(AuditMetadataBuildingOptions options, MiddleIdData referencingIdData, String referencedEntityName, MiddleIdData referencedIdData, boolean revisionTypeInId, String mappedBy, boolean mappedByKey, String orderBy) {
        super(options, options.getAuditEntityName(referencedEntityName), referencingIdData, revisionTypeInId, orderBy);
        this.mappedBy = mappedBy;
        this.referencedIdData = referencedIdData;
        this.multipleIdMapperKey = referencedIdData.getOriginalMapper() instanceof MultipleIdMapper && mappedByKey;
    }

    @Override
    protected QueryBuilder buildQueryBuilderCommon(SessionFactoryImplementor sessionFactory) {
        QueryBuilder qb = new QueryBuilder(this.entityName, "e__", sessionFactory);
        qb.addProjection(null, "e__", null, false);
        if (this.multipleIdMapperKey) {
            IdMapper mapper = this.getMultipleIdPrefixedMapper();
            mapper.addNamedIdEqualsToQuery(qb.getRootParameters(), null, this.referencingIdData.getPrefixedMapper(), true);
        } else {
            this.referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(qb.getRootParameters(), null, true);
        }
        if (!StringHelper.isEmpty(this.orderBy)) {
            qb.addOrderFragment("e__", this.orderBy);
        }
        return qb;
    }

    @Override
    protected void applyValidPredicates(QueryBuilder qb, Parameters rootParameters, boolean inclusive) {
        String revisionPropertyPath = this.options.getRevisionNumberPath();
        this.options.getAuditStrategy().addEntityAtRevisionRestriction(this.options, qb, rootParameters, revisionPropertyPath, this.options.getRevisionEndFieldName(), true, this.referencedIdData, revisionPropertyPath, this.options.getOriginalIdPropName(), "e__", "e2__", true);
        rootParameters.addWhereWithNamedParam(this.getRevisionTypePath(), false, "!=", "delrevisiontype");
    }

    @Override
    protected void applyValidAndRemovePredicates(QueryBuilder remQb) {
        Parameters disjoint = remQb.getRootParameters().addSubParameters("or");
        Parameters valid = disjoint.addSubParameters("and");
        Parameters removed = disjoint.addSubParameters("and");
        this.applyValidPredicates(remQb, valid, false);
        removed.addWhereWithNamedParam(this.options.getRevisionNumberPath(), false, "=", "revision");
        removed.addWhereWithNamedParam(this.getRevisionTypePath(), false, "=", "delrevisiontype");
    }

    private IdMapper getMultipleIdPrefixedMapper() {
        String prefix = this.options.getOriginalIdPropName() + "." + this.mappedBy + ".";
        return this.referencingIdData.getOriginalMapper().prefixMappedProperties(prefix);
    }
}

