/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.query;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.boot.spi.AuditMetadataBuildingOptions;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.query.AbstractRelationQueryGenerator;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;

public final class OneEntityQueryGenerator
extends AbstractRelationQueryGenerator {
    private final MiddleComponentData[] componentDatas;

    public OneEntityQueryGenerator(AuditMetadataBuildingOptions options, String versionsMiddleEntityName, MiddleIdData referencingIdData, boolean revisionTypeInId, MiddleComponentData ... componentData) {
        super(options, versionsMiddleEntityName, referencingIdData, revisionTypeInId, null);
        this.componentDatas = componentData;
    }

    @Override
    protected QueryBuilder buildQueryBuilderCommon(SessionFactoryImplementor sessionFactory) {
        QueryBuilder qb = new QueryBuilder(this.entityName, "ee__", sessionFactory);
        qb.addProjection(null, "ee__", null, false);
        this.referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(qb.getRootParameters(), this.options.getOriginalIdPropName(), true);
        return qb;
    }

    @Override
    protected void applyValidPredicates(QueryBuilder qb, Parameters rootParameters, boolean inclusive) {
        String revisionPropertyPath = this.options.getRevisionNumberPath();
        String originalIdPropertyName = this.options.getOriginalIdPropName();
        String eeOriginalIdPropertyPath = "ee__." + originalIdPropertyName;
        this.options.getAuditStrategy().addAssociationAtRevisionRestriction(qb, rootParameters, revisionPropertyPath, this.options.getRevisionEndFieldName(), true, this.referencingIdData, this.entityName, eeOriginalIdPropertyPath, revisionPropertyPath, originalIdPropertyName, "ee__", inclusive, this.componentDatas);
        rootParameters.addWhereWithNamedParam(this.getRevisionTypePath(), "!=", "delrevisiontype");
    }

    @Override
    protected void applyValidAndRemovePredicates(QueryBuilder remQb) {
        Parameters disjoint = remQb.getRootParameters().addSubParameters("or");
        Parameters valid = disjoint.addSubParameters("and");
        Parameters removed = disjoint.addSubParameters("and");
        this.applyValidPredicates(remQb, valid, false);
        removed.addWhereWithNamedParam(this.options.getRevisionNumberPath(), "=", "revision");
        removed.addWhereWithNamedParam(this.getRevisionTypePath(), "=", "delrevisiontype");
    }
}

