/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.query;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.boot.spi.AuditMetadataBuildingOptions;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.query.AbstractRelationQueryGenerator;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.internal.util.StringHelper;

public final class TwoEntityQueryGenerator
extends AbstractRelationQueryGenerator {
    private final MiddleIdData referencedIdData;
    private final MiddleComponentData[] componentDatas;

    public TwoEntityQueryGenerator(AuditMetadataBuildingOptions options, String versionsMiddleEntityName, MiddleIdData referencingIdData, MiddleIdData referencedIdData, boolean revisionTypeInId, String orderBy, MiddleComponentData ... componentData) {
        super(options, versionsMiddleEntityName, referencingIdData, revisionTypeInId, orderBy);
        this.referencedIdData = referencedIdData;
        this.componentDatas = componentData;
    }

    @Override
    protected QueryBuilder buildQueryBuilderCommon(SessionFactoryImplementor sessionFactory) {
        String originalIdPropertyName = this.options.getOriginalIdPropName();
        String eeOriginalIdPropertyPath = "ee__." + originalIdPropertyName;
        QueryBuilder qb = new QueryBuilder(this.entityName, "ee__", sessionFactory);
        qb.addFrom(this.referencedIdData.getAuditEntityName(), "e__", false);
        qb.addProjection("new list", "ee__, e__", null, false);
        Parameters rootParameters = qb.getRootParameters();
        this.referencedIdData.getPrefixedMapper().addIdsEqualToQuery(rootParameters, eeOriginalIdPropertyPath, this.referencedIdData.getOriginalMapper(), "e__." + originalIdPropertyName);
        this.referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(rootParameters, originalIdPropertyName, true);
        if (!StringHelper.isEmpty(this.orderBy)) {
            qb.addOrderFragment("e__", this.orderBy);
        }
        return qb;
    }

    @Override
    protected void applyValidPredicates(QueryBuilder qb, Parameters rootParameters, boolean inclusive) {
        String revisionPropertyPath = this.options.getRevisionNumberPath();
        String originalIdPropertyName = this.options.getOriginalIdPropName();
        String eeOriginalIdPropertyPath = "ee__." + originalIdPropertyName;
        String revisionTypePropName = this.getRevisionTypePath();
        this.options.getAuditStrategy().addEntityAtRevisionRestriction(this.options, qb, rootParameters, "e__." + revisionPropertyPath, "e__." + this.options.getRevisionEndFieldName(), false, this.referencedIdData, revisionPropertyPath, originalIdPropertyName, "e__", "e2__", true);
        this.options.getAuditStrategy().addAssociationAtRevisionRestriction(qb, rootParameters, revisionPropertyPath, this.options.getRevisionEndFieldName(), true, this.referencingIdData, this.entityName, eeOriginalIdPropertyPath, revisionPropertyPath, originalIdPropertyName, "ee__", inclusive, this.componentDatas);
        rootParameters.addWhereWithNamedParam(revisionTypePropName, "!=", "delrevisiontype");
        rootParameters.addWhereWithNamedParam("e__." + revisionTypePropName, false, "!=", "delrevisiontype");
    }

    @Override
    protected void applyValidAndRemovePredicates(QueryBuilder remQb) {
        Parameters disjoint = remQb.getRootParameters().addSubParameters("or");
        Parameters valid = disjoint.addSubParameters("and");
        Parameters removed = disjoint.addSubParameters("and");
        String revisionPropertyPath = this.options.getRevisionNumberPath();
        String revisionTypePropName = this.getRevisionTypePath();
        this.applyValidPredicates(remQb, valid, false);
        removed.addWhereWithNamedParam(revisionPropertyPath, "=", "revision");
        removed.addWhereWithNamedParam("e__." + revisionPropertyPath, false, "=", "revision");
        removed.addWhereWithNamedParam(revisionTypePropName, "=", "delrevisiontype");
        removed.addWhereWithNamedParam("e__." + revisionTypePropName, false, "=", "delrevisiontype");
    }
}

