/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.revisioninfo;

import java.lang.reflect.InvocationTargetException;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.envers.EntityTrackingRevisionListener;
import org.hibernate.envers.RevisionListener;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoGenerator;
import org.hibernate.envers.internal.revisioninfo.RevisionTimestampValueResolver;
import org.hibernate.envers.internal.synchronization.SessionCacheCleaner;
import org.hibernate.internal.util.ReflectHelper;

public class DefaultRevisionInfoGenerator
implements RevisionInfoGenerator {
    private final String revisionInfoEntityName;
    private final RevisionListener listener;
    private final Class<?> revisionInfoClass;
    private final SessionCacheCleaner sessionCacheCleaner;
    private final RevisionTimestampValueResolver timestampValueResolver;

    public DefaultRevisionInfoGenerator(String revisionInfoEntityName, Class<?> revisionInfoClass, Class<? extends RevisionListener> listenerClass, RevisionTimestampValueResolver timestampValueResolver) {
        this.revisionInfoEntityName = revisionInfoEntityName;
        this.revisionInfoClass = revisionInfoClass;
        this.timestampValueResolver = timestampValueResolver;
        if (!listenerClass.equals(RevisionListener.class)) {
            try {
                this.listener = ReflectHelper.getDefaultConstructor(listenerClass).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new MappingException(e);
            }
            catch (IllegalAccessException e) {
                throw new MappingException(e);
            }
            catch (InvocationTargetException e) {
                throw new MappingException(e);
            }
        } else {
            this.listener = null;
        }
        this.sessionCacheCleaner = new SessionCacheCleaner();
    }

    @Override
    public void saveRevisionData(Session session, Object revisionData) {
        session.save(this.revisionInfoEntityName, revisionData);
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, revisionData);
    }

    @Override
    public Object generate() {
        Object revisionInfo;
        try {
            revisionInfo = ReflectHelper.getDefaultConstructor(this.revisionInfoClass).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.timestampValueResolver.resolveNow(revisionInfo);
        if (this.listener != null) {
            this.listener.newRevision(revisionInfo);
        }
        return revisionInfo;
    }

    @Override
    public void entityChanged(Class entityClass, String entityName, Object entityId, RevisionType revisionType, Object revisionInfo) {
        if (this.listener instanceof EntityTrackingRevisionListener) {
            ((EntityTrackingRevisionListener)this.listener).entityChanged(entityClass, entityName, entityId, revisionType, revisionInfo);
        }
    }
}

