/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.revisioninfo;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.hibernate.envers.internal.entities.RevisionTimestampData;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.service.ServiceRegistry;

public class RevisionTimestampValueResolver {
    private final RevisionTimestampData timestampData;
    private final Setter revisionTimestampSetter;

    public RevisionTimestampValueResolver(Class<?> revisionInfoClass, RevisionTimestampData timestampData, ServiceRegistry serviceRegistry) {
        this.timestampData = timestampData;
        this.revisionTimestampSetter = ReflectionTools.getSetter(revisionInfoClass, timestampData, serviceRegistry);
    }

    public String getName() {
        return this.timestampData.getName();
    }

    public void resolveNow(Object object) {
        if (this.timestampData.isTimestampDate()) {
            this.revisionTimestampSetter.set(object, new Date(), null);
        } else if (this.timestampData.isTimestampLocalDateTime()) {
            this.revisionTimestampSetter.set(object, LocalDateTime.now(), null);
        } else {
            this.revisionTimestampSetter.set(object, System.currentTimeMillis(), null);
        }
    }

    public Object resolveByValue(Date date) {
        if (date != null) {
            if (this.timestampData.isTimestampDate()) {
                return date;
            }
            if (this.timestampData.isTimestampLocalDateTime()) {
                return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            }
            return date.getTime();
        }
        return null;
    }

    public Object resolveByValue(LocalDateTime localDateTime) {
        if (localDateTime != null) {
            if (this.timestampData.isTimestampDate()) {
                return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
            }
            if (this.timestampData.isTimestampLocalDateTime()) {
                return localDateTime;
            }
            return localDateTime.atZone(ZoneId.systemDefault()).toInstant().getEpochSecond();
        }
        return null;
    }
}

