/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.synchronization.work;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.internal.synchronization.work.AuditWorkUnit;

public abstract class AbstractAuditWorkUnit
implements AuditWorkUnit {
    protected final SessionImplementor sessionImplementor;
    protected final AuditService auditService;
    protected final Object id;
    protected final String entityName;
    protected final RevisionType revisionType;
    private Object performedData;

    protected AbstractAuditWorkUnit(SessionImplementor sessionImplementor, String entityName, AuditService auditService, Object id, RevisionType revisionType) {
        this.sessionImplementor = sessionImplementor;
        this.auditService = auditService;
        this.id = id;
        this.entityName = entityName;
        this.revisionType = revisionType;
    }

    protected void fillDataWithId(Map<String, Object> data, Object revision) {
        HashMap<String, Object> originalId = new HashMap<String, Object>();
        originalId.put(this.auditService.getOptions().getRevisionFieldName(), revision);
        this.auditService.getEntityBindings().get(this.getEntityName()).getIdMapper().mapToMapFromId(originalId, this.id);
        data.put(this.auditService.getOptions().getRevisionTypePropName(), (Object)this.revisionType);
        data.put(this.auditService.getOptions().getOriginalIdPropName(), originalId);
    }

    @Override
    public void perform(Session session, Object revisionData) {
        Map<String, Object> data = this.generateData(revisionData);
        this.auditService.getOptions().getAuditStrategy().perform(session, this.getEntityName(), this.auditService, this.id, data, revisionData);
        this.setPerformed(data);
    }

    @Override
    public Object getEntityId() {
        return this.id;
    }

    @Override
    public boolean isPerformed() {
        return this.performedData != null;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    protected void setPerformed(Object performedData) {
        this.performedData = performedData;
    }

    @Override
    public void undo(Session session) {
        if (this.isPerformed()) {
            session.delete(this.auditService.getAuditEntityName(this.entityName), this.performedData);
            session.flush();
        }
    }

    @Override
    public RevisionType getRevisionType() {
        return this.revisionType;
    }
}

