/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.synchronization.work;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.internal.synchronization.work.AbstractAuditWorkUnit;
import org.hibernate.envers.internal.synchronization.work.AddWorkUnit;
import org.hibernate.envers.internal.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.internal.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.internal.synchronization.work.FakeBidirectionalRelationWorkUnit;
import org.hibernate.envers.internal.synchronization.work.ModWorkUnit;
import org.hibernate.envers.internal.synchronization.work.WorkUnitMergeVisitor;
import org.hibernate.envers.internal.tools.ArraysTools;
import org.hibernate.envers.internal.tools.EntityTools;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;

public class DelWorkUnit
extends AbstractAuditWorkUnit
implements AuditWorkUnit {
    private final Object[] state;
    private final EntityTypeDescriptor entityDescriptor;
    private final String[] propertyNames;

    public DelWorkUnit(SessionImplementor sessionImplementor, String entityName, AuditService auditService, Object id, EntityTypeDescriptor entityDescriptor, Object[] state) {
        super(sessionImplementor, entityName, auditService, id, RevisionType.DEL);
        this.state = state;
        this.entityDescriptor = entityDescriptor;
        this.propertyNames = EntityTools.getPropertyNames(entityDescriptor);
    }

    @Override
    public boolean containsWork() {
        return true;
    }

    @Override
    public Map<String, Object> generateData(Object revisionData) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.fillDataWithId(data, revisionData);
        if (this.auditService.getOptions().isStoreDataAtDeleteEnabled()) {
            this.auditService.getEntityBindings().get(this.getEntityName()).getPropertyMapper().map(this.sessionImplementor, data, this.propertyNames, this.state, this.state);
        } else {
            this.auditService.getEntityBindings().get(this.getEntityName()).getPropertyMapper().map(this.sessionImplementor, data, this.propertyNames, null, this.state);
        }
        return data;
    }

    @Override
    public AuditWorkUnit merge(AddWorkUnit second) {
        if (ArraysTools.arraysEqual(second.getState(), this.state)) {
            return null;
        }
        return new ModWorkUnit(this.sessionImplementor, this.entityName, this.auditService, this.id, this.entityDescriptor, second.getState(), this.state);
    }

    @Override
    public AuditWorkUnit merge(ModWorkUnit second) {
        return null;
    }

    @Override
    public AuditWorkUnit merge(DelWorkUnit second) {
        return this;
    }

    @Override
    public AuditWorkUnit merge(CollectionChangeWorkUnit second) {
        return this;
    }

    @Override
    public AuditWorkUnit merge(FakeBidirectionalRelationWorkUnit second) {
        return this;
    }

    @Override
    public AuditWorkUnit dispatch(WorkUnitMergeVisitor first) {
        return first.merge(this);
    }
}

