/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.synchronization.work;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.internal.synchronization.work.AbstractAuditWorkUnit;
import org.hibernate.envers.internal.synchronization.work.AddWorkUnit;
import org.hibernate.envers.internal.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.internal.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.internal.synchronization.work.DelWorkUnit;
import org.hibernate.envers.internal.synchronization.work.FakeBidirectionalRelationWorkUnit;
import org.hibernate.envers.internal.synchronization.work.WorkUnitMergeVisitor;
import org.hibernate.envers.internal.tools.EntityTools;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;

public class ModWorkUnit
extends AbstractAuditWorkUnit
implements AuditWorkUnit {
    private final Map<String, Object> data;
    private final boolean changes;
    private final EntityTypeDescriptor entityDescriptor;
    private final Object[] oldState;
    private final Object[] newState;

    public ModWorkUnit(SessionImplementor sessionImplementor, String entityName, AuditService auditService, Object id, EntityTypeDescriptor entityDescriptor, Object[] newState, Object[] oldState) {
        super(sessionImplementor, entityName, auditService, id, RevisionType.MOD);
        this.entityDescriptor = entityDescriptor;
        this.oldState = oldState;
        this.newState = newState;
        this.data = new HashMap<String, Object>();
        this.changes = auditService.getEntityBindings().get(this.getEntityName()).getPropertyMapper().map(sessionImplementor, this.data, EntityTools.getPropertyNames(entityDescriptor), newState, oldState);
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    @Override
    public boolean containsWork() {
        return this.changes;
    }

    @Override
    public Map<String, Object> generateData(Object revisionData) {
        this.fillDataWithId(this.data, revisionData);
        return this.data;
    }

    @Override
    public AuditWorkUnit merge(AddWorkUnit second) {
        return this;
    }

    @Override
    public AuditWorkUnit merge(ModWorkUnit second) {
        return new ModWorkUnit(second.sessionImplementor, second.getEntityName(), second.auditService, second.id, second.entityDescriptor, second.newState, this.oldState);
    }

    @Override
    public AuditWorkUnit merge(DelWorkUnit second) {
        return second;
    }

    @Override
    public AuditWorkUnit merge(CollectionChangeWorkUnit second) {
        second.mergeCollectionModifiedData(this.data);
        return this;
    }

    @Override
    public AuditWorkUnit merge(FakeBidirectionalRelationWorkUnit second) {
        return FakeBidirectionalRelationWorkUnit.merge(second, this, second.getNestedWorkUnit());
    }

    @Override
    public AuditWorkUnit dispatch(WorkUnitMergeVisitor first) {
        return first.merge(this);
    }
}

