/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools;

import org.hibernate.boot.model.domain.ValueMapping;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;

public abstract class MappingTools {
    public static String createComponentPrefix(String componentName) {
        return componentName + "_";
    }

    public static String createToOneRelationPrefix(String referencePropertyName) {
        return referencePropertyName + "_";
    }

    public static String getReferencedEntityName(Value value) {
        if (value instanceof ToOne) {
            return ((ToOne)value).getReferencedEntityName();
        }
        if (value instanceof OneToMany) {
            return ((OneToMany)value).getReferencedEntityName();
        }
        if (value instanceof Collection) {
            return MappingTools.getReferencedEntityName(((Collection)value).getElement());
        }
        return null;
    }

    public static boolean ignoreNotFound(ValueMapping value) {
        if (value instanceof ManyToOne) {
            return ((ManyToOne)value).isIgnoreNotFound();
        }
        if (value instanceof OneToMany) {
            return ((OneToMany)value).isIgnoreNotFound();
        }
        return false;
    }
}

