/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.hibernate.envers.internal.tools.graph.GraphDefiner;
import org.hibernate.envers.internal.tools.graph.TopologicalSort;
import org.hibernate.envers.internal.tools.graph.Vertex;

public final class GraphTopologicalSort {
    private GraphTopologicalSort() {
    }

    public static <V, R> List<V> sort(GraphDefiner<V, R> definer) {
        Collection<V> values = definer.getValues();
        HashMap<R, Vertex<R>> vertices = new HashMap<R, Vertex<R>>();
        for (V v : values) {
            R rep = definer.getRepresentation(v);
            vertices.put(rep, new Vertex<R>(rep));
        }
        for (V v : values) {
            for (V vn : definer.getNeighbours(v)) {
                ((Vertex)vertices.get(definer.getRepresentation(v))).addNeighbour((Vertex)vertices.get(definer.getRepresentation(vn)));
            }
        }
        List sortedReps = new TopologicalSort().sort(vertices.values());
        ArrayList<V> sortedValues = new ArrayList<V>(sortedReps.size());
        for (Object rep : sortedReps) {
            sortedValues.add(definer.getValue(rep));
        }
        return sortedValues;
    }
}

