/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.criteria.JoinType;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.envers.internal.tools.MutableInteger;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.internal.tools.Triple;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.tools.Pair;
import org.hibernate.query.Query;
import org.jboss.logging.Logger;

public class QueryBuilder {
    private static final Logger log = Logger.getLogger(QueryBuilder.class);
    private final String entityName;
    private final String alias;
    private final MutableInteger aliasCounter;
    private final MutableInteger paramCounter;
    private final List<Parameters> parameters = new ArrayList<Parameters>();
    private final List<JoinParameter> froms;
    private final List<Triple<String, String, Boolean>> orders;
    private final List<String> projections;
    private final List<Pair<String, String>> orderFragments;
    private final SessionFactoryImplementor sessionFactory;

    public QueryBuilder(String entityName, String alias, SessionFactoryImplementor sessionFactory) {
        this(entityName, alias, new MutableInteger(), new MutableInteger(), sessionFactory);
    }

    private QueryBuilder(String entityName, String alias, MutableInteger aliasCounter, MutableInteger paramCounter, SessionFactoryImplementor sessionFactory) {
        this.entityName = entityName;
        this.alias = alias;
        this.aliasCounter = aliasCounter;
        this.paramCounter = paramCounter;
        this.sessionFactory = sessionFactory;
        Parameters rootParameters = new Parameters(alias, "and", paramCounter);
        this.parameters.add(rootParameters);
        this.froms = new ArrayList<JoinParameter>();
        this.orders = new ArrayList<Triple<String, String, Boolean>>();
        this.projections = new ArrayList<String>();
        this.orderFragments = new ArrayList<Pair<String, String>>();
        this.addFrom(entityName, alias, true);
    }

    private QueryBuilder(QueryBuilder other) {
        this.entityName = other.entityName;
        this.alias = other.alias;
        this.sessionFactory = other.sessionFactory;
        this.aliasCounter = other.aliasCounter.deepCopy();
        this.paramCounter = other.paramCounter.deepCopy();
        for (Parameters params : other.parameters) {
            this.parameters.add(params.deepCopy());
        }
        this.froms = new ArrayList<JoinParameter>(other.froms);
        this.orders = new ArrayList<Triple<String, String, Boolean>>(other.orders);
        this.projections = new ArrayList<String>(other.projections);
        this.orderFragments = new ArrayList<Pair<String, String>>(other.orderFragments);
    }

    public QueryBuilder deepCopy() {
        return new QueryBuilder(this);
    }

    public String getAlias() {
        return this.alias;
    }

    public void addFrom(String entityName, String alias, boolean select) {
        CrossJoinParameter joinParameter = new CrossJoinParameter(entityName, alias, select);
        this.froms.add(joinParameter);
    }

    public Parameters addJoin(JoinType joinType, String entityName, String alias, boolean select) {
        Parameters joinConditionParameters = new Parameters(alias, "and", this.paramCounter);
        InnerOuterJoinParameter joinParameter = new InnerOuterJoinParameter(joinType, entityName, alias, select, joinConditionParameters);
        this.froms.add(joinParameter);
        return joinConditionParameters;
    }

    public String generateAlias() {
        return "_e" + this.aliasCounter.getAndIncrease();
    }

    public QueryBuilder newSubQueryBuilder(String entityName, String alias) {
        return new QueryBuilder(entityName, alias, this.aliasCounter, this.paramCounter, this.sessionFactory);
    }

    public Parameters getRootParameters() {
        return this.parameters.get(0);
    }

    public Parameters addParameters(String alias) {
        Parameters result = new Parameters(alias, "and", this.paramCounter);
        this.parameters.add(result);
        return result;
    }

    public void addOrder(String alias, String propertyName, boolean ascending) {
        this.orders.add(Triple.make(alias, propertyName, ascending));
    }

    public void addOrderFragment(String alias, String fragment) {
        this.orderFragments.add(Pair.make(alias, fragment));
    }

    public void addProjection(String function, String alias, String propertyName, boolean distinct) {
        String effectivePropertyName;
        String string = effectivePropertyName = propertyName == null ? "" : ".".concat(propertyName);
        if (function == null) {
            this.projections.add((distinct ? "distinct " : "") + alias + effectivePropertyName);
        } else {
            this.projections.add(function + "(" + (distinct ? "distinct " : "") + alias + effectivePropertyName + ")");
        }
    }

    public void build(StringBuilder sb, Map<String, Object> queryParamValues) {
        sb.append("select ");
        if (this.projections.size() > 0) {
            StringTools.append(sb, this.projections.iterator(), ", ");
        } else {
            StringTools.append(sb, this.getSelectAliasList().iterator(), ", ");
        }
        sb.append(" from ");
        boolean first = true;
        for (JoinParameter joinParameter : this.froms) {
            joinParameter.appendJoin(first, sb, queryParamValues);
            first = false;
        }
        first = true;
        for (Parameters params : this.parameters) {
            if (params.isEmpty()) continue;
            if (first) {
                sb.append(" where ");
                first = false;
            } else {
                sb.append(" and ");
            }
            params.build(sb, queryParamValues);
        }
        if (!this.orders.isEmpty()) {
            sb.append(" order by ");
            StringTools.append(sb, this.getOrderList().iterator(), ", ");
        } else if (!this.orderFragments.isEmpty()) {
            throw new NotYetImplementedFor6Exception();
        }
    }

    private List<String> getSelectAliasList() {
        ArrayList<String> aliasList = new ArrayList<String>();
        for (JoinParameter from : this.froms) {
            if (!from.isSelect()) continue;
            aliasList.add(from.getAlias());
        }
        return aliasList;
    }

    public String getRootAlias() {
        return this.alias;
    }

    private List<String> getOrderList() {
        ArrayList<String> orderList = new ArrayList<String>();
        for (Triple<String, String, Boolean> order : this.orders) {
            orderList.add(order.getFirst() + "." + order.getSecond() + " " + (order.getThird() != false ? "asc" : "desc"));
        }
        return orderList;
    }

    public Query toQuery(SharedSessionContractImplementor session) {
        StringBuilder querySb = new StringBuilder();
        HashMap<String, Object> queryParamValues = new HashMap<String, Object>();
        this.build(querySb, queryParamValues);
        String hql = querySb.toString();
        log.infof("HQL: %s", (Object)hql);
        Query query = session.createQuery(hql);
        for (Map.Entry paramValue : queryParamValues.entrySet()) {
            query.setParameter((String)paramValue.getKey(), paramValue.getValue());
        }
        return query;
    }

    private static class InnerOuterJoinParameter
    extends JoinParameter {
        private final JoinType joinType;
        private final String entityName;
        private final Parameters joinConditionParameters;

        public InnerOuterJoinParameter(JoinType joinType, String entityName, String alias, boolean select, Parameters joinConditionParameters) {
            super(alias, select);
            this.joinType = joinType;
            this.entityName = entityName;
            this.joinConditionParameters = joinConditionParameters;
        }

        @Override
        public void appendJoin(boolean firstFromElement, StringBuilder builder, Map<String, Object> queryParamValues) {
            if (firstFromElement) {
                throw new IllegalArgumentException("An inner/outer join cannot come as first 'from element'");
            }
            builder.append(' ').append(this.joinType.name().toLowerCase(Locale.US)).append(" join ").append(this.entityName).append(' ').append(this.getAlias()).append(" on ");
            this.joinConditionParameters.build(builder, queryParamValues);
        }
    }

    private static class CrossJoinParameter
    extends JoinParameter {
        private final String entityName;

        public CrossJoinParameter(String entityName, String alias, boolean select) {
            super(alias, select);
            this.entityName = entityName;
        }

        @Override
        public void appendJoin(boolean firstFromElement, StringBuilder builder, Map<String, Object> queryParamValues) {
            if (!firstFromElement) {
                builder.append(", ");
            }
            builder.append(this.entityName).append(' ').append(this.getAlias());
        }
    }

    private static abstract class JoinParameter {
        private final String alias;
        private final boolean select;

        protected JoinParameter(String alias, boolean select) {
            this.alias = alias;
            this.select = select;
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean isSelect() {
            return this.select;
        }

        public abstract void appendJoin(boolean var1, StringBuilder var2, Map<String, Object> var3);
    }
}

