/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.entities.RelationType;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifierCompositeNonAggregated;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;

public abstract class CriteriaTools {
    public static void checkPropertyNotARelation(AuditService auditService, String entityName, String propertyName) throws AuditException {
        if (auditService.getEntityBindings().get(entityName).isRelation(propertyName)) {
            throw new AuditException("This criterion cannot be used on a property that is a relation to another property.");
        }
    }

    public static RelationDescription getRelatedEntity(AuditService auditService, String entityName, String propertyName) throws AuditException {
        RelationDescription relationDesc = auditService.getEntityBindings().getRelationDescription(entityName, propertyName);
        if (relationDesc == null) {
            return null;
        }
        if (relationDesc.getRelationType() == RelationType.TO_ONE) {
            return relationDesc;
        }
        throw new AuditException("This type of relation (" + entityName + "." + propertyName + ") isn't supported and can't be used in queries.");
    }

    public static String determinePropertyName(AuditReaderImplementor versionsReader, String entityName, PropertyNameGetter propertyNameGetter) {
        AuditService auditService = versionsReader.getAuditService();
        return CriteriaTools.determinePropertyName(versionsReader, entityName, propertyNameGetter.get(auditService));
    }

    public static String determinePropertyName(AuditReaderImplementor versionsReader, String entityName, String propertyName) {
        SessionFactoryImplementor sessionFactory = versionsReader.getSessionImplementor().getFactory();
        AuditService auditService = versionsReader.getAuditService();
        if ("$$id$$".equals(propertyName)) {
            String identifierPropertyName = sessionFactory.getMetamodel().findEntityDescriptor(entityName).getIdentifierPropertyName();
            propertyName = auditService.getOptions().getOriginalIdPropName() + "." + identifierPropertyName;
        } else {
            List<String> identifierPropertyNames = CriteriaTools.identifierPropertyNames(sessionFactory, entityName);
            if (identifierPropertyNames.contains(propertyName)) {
                propertyName = auditService.getOptions().getOriginalIdPropName() + "." + propertyName;
            }
        }
        return propertyName;
    }

    private static List<String> identifierPropertyNames(SessionFactoryImplementor sessionFactory, String entityName) {
        String identifierPropertyName = sessionFactory.getMetamodel().findEntityDescriptor(entityName).getIdentifierPropertyName();
        if (identifierPropertyName != null) {
            return Arrays.asList(identifierPropertyName);
        }
        EntityTypeDescriptor entityDescriptor = sessionFactory.getMetamodel().findEntityDescriptor(entityName);
        EntityIdentifier entityIdentifier = entityDescriptor.getIdentifierDescriptor();
        if (entityIdentifier instanceof EntityIdentifierCompositeNonAggregated) {
            EntityIdentifierCompositeNonAggregated embeddedId = (EntityIdentifierCompositeNonAggregated)EntityIdentifierCompositeNonAggregated.class.cast(entityIdentifier);
            ArrayList<String> result = new ArrayList<String>();
            for (PersistentAttributeDescriptor persistentAttributeDescriptor : embeddedId.getEmbeddedDescriptor().getPersistentAttributes()) {
                result.add(persistentAttributeDescriptor.getAttributeName());
            }
            return result;
        }
        return Collections.emptyList();
    }
}

