/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.internal.AbstractAtomicExpression;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;

public class InAuditExpression
extends AbstractAtomicExpression {
    private PropertyNameGetter propertyNameGetter;
    private Object[] values;

    public InAuditExpression(String alias, PropertyNameGetter propertyNameGetter, Object[] values) {
        super(alias);
        this.propertyNameGetter = propertyNameGetter;
        this.values = values;
    }

    @Override
    protected void addToQuery(AuditReaderImplementor versionsReader, String entityName, String alias, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(versionsReader, entityName, this.propertyNameGetter);
        CriteriaTools.checkPropertyNotARelation(versionsReader.getAuditService(), entityName, propertyName);
        parameters.addWhereWithParams(alias, propertyName, "in (", this.values, ")");
    }
}

