/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.internal.AbstractAtomicExpression;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;

public class NotNullAuditExpression
extends AbstractAtomicExpression {
    private PropertyNameGetter propertyNameGetter;

    public NotNullAuditExpression(String alias, PropertyNameGetter propertyNameGetter) {
        super(alias);
        this.propertyNameGetter = propertyNameGetter;
    }

    @Override
    protected void addToQuery(AuditReaderImplementor versionsReader, String entityName, String alias, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(versionsReader, entityName, this.propertyNameGetter);
        RelationDescription relatedEntity = CriteriaTools.getRelatedEntity(versionsReader.getAuditService(), entityName, propertyName);
        if (relatedEntity == null) {
            parameters.addNotNullRestriction(alias, propertyName);
        } else {
            relatedEntity.getIdMapper().addIdEqualsToQuery(parameters, null, alias, null, false);
        }
    }
}

