/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import java.util.Map;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;

public class PropertyAuditExpression
implements AuditCriterion {
    private String alias;
    private PropertyNameGetter propertyNameGetter;
    private String otherAlias;
    private String otherPropertyName;
    private String op;

    public PropertyAuditExpression(String alias, PropertyNameGetter propertyNameGetter, String otherAlias, String otherPropertyName, String op) {
        this.alias = alias;
        this.propertyNameGetter = propertyNameGetter;
        this.otherAlias = otherAlias;
        this.otherPropertyName = otherPropertyName;
        this.op = op;
    }

    @Override
    public void addToQuery(AuditReaderImplementor versionsReader, Map<String, String> aliasToEntityNameMap, String baseAlias, QueryBuilder qb, Parameters parameters) {
        String effectiveAlias = this.alias == null ? baseAlias : this.alias;
        String effectiveOtherAlias = this.otherAlias == null ? baseAlias : this.otherAlias;
        String entityName = aliasToEntityNameMap.get(effectiveAlias);
        String otherEntityName = aliasToEntityNameMap.get(effectiveOtherAlias);
        String propertyName = CriteriaTools.determinePropertyName(versionsReader, entityName, this.propertyNameGetter);
        CriteriaTools.checkPropertyNotARelation(versionsReader.getAuditService(), entityName, propertyName);
        if (versionsReader.getAuditService().getEntityBindings().isVersioned(otherEntityName)) {
            CriteriaTools.checkPropertyNotARelation(versionsReader.getAuditService(), otherEntityName, this.otherPropertyName);
        }
        parameters.addWhere(effectiveAlias, propertyName, this.op, effectiveOtherAlias, this.otherPropertyName);
    }
}

