/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.internal.AbstractAtomicExpression;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;

public class RelatedAuditEqualityExpression
extends AbstractAtomicExpression {
    private final PropertyNameGetter propertyNameGetter;
    private final Object id;
    private final boolean equals;

    public RelatedAuditEqualityExpression(String alias, PropertyNameGetter propertyNameGetter, Object id, boolean equals) {
        super(alias);
        this.propertyNameGetter = propertyNameGetter;
        this.id = id;
        this.equals = equals;
    }

    @Override
    protected void addToQuery(AuditReaderImplementor versionsReader, String entityName, String alias, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(versionsReader, entityName, this.propertyNameGetter);
        RelationDescription relatedEntity = CriteriaTools.getRelatedEntity(versionsReader.getAuditService(), entityName, propertyName);
        if (relatedEntity == null) {
            throw new AuditException("This criterion can only be used on a property that is a relation to another property.");
        }
        relatedEntity.getIdMapper().addIdEqualsToQuery(parameters, this.id, alias, null, this.equals);
    }
}

