/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import java.util.List;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.internal.AbstractAtomicExpression;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;

public class RelatedAuditInExpression
extends AbstractAtomicExpression {
    private final PropertyNameGetter propertyNameGetter;
    private final Object[] ids;

    public RelatedAuditInExpression(String alias, PropertyNameGetter propertyNameGetter, Object[] ids) {
        super(alias);
        this.propertyNameGetter = propertyNameGetter;
        this.ids = ids;
    }

    @Override
    protected void addToQuery(AuditReaderImplementor versionsReader, String entityName, String alias, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(versionsReader, entityName, this.propertyNameGetter);
        RelationDescription relatedEntity = CriteriaTools.getRelatedEntity(versionsReader.getAuditService(), entityName, propertyName);
        if (relatedEntity == null) {
            throw new AuditException("The criterion can only be used on a property that is a relation to another property.");
        }
        List<QueryParameterData> qpdList = relatedEntity.getIdMapper().mapToQueryParametersFromId(propertyName);
        if (qpdList != null) {
            QueryParameterData qpd = qpdList.iterator().next();
            parameters.addWhereWithParams(alias, qpd.getQueryParameterName(), "in (", this.ids, ")");
        }
    }
}

