/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import java.util.List;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.internal.AbstractAtomicExpression;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEmbedded;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;

public class SimpleAuditExpression
extends AbstractAtomicExpression {
    private PropertyNameGetter propertyNameGetter;
    private Object value;
    private String op;

    public SimpleAuditExpression(String alias, PropertyNameGetter propertyNameGetter, Object value, String op) {
        super(alias);
        this.propertyNameGetter = propertyNameGetter;
        this.value = value;
        this.op = op;
    }

    @Override
    protected void addToQuery(AuditReaderImplementor versionsReader, String entityName, String alias, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(versionsReader, entityName, this.propertyNameGetter);
        RelationDescription relatedEntity = CriteriaTools.getRelatedEntity(versionsReader.getAuditService(), entityName, propertyName);
        if (relatedEntity == null) {
            SessionImplementor session = versionsReader.getSessionImplementor();
            PersistentAttributeDescriptor persistentAttribute = this.getPersistentAttribute(session, entityName, propertyName);
            if (persistentAttribute != null && persistentAttribute instanceof SingularPersistentAttributeEmbedded) {
                if (!"=".equals(this.op) && !"<>".equals(this.op)) {
                    throw new AuditException("Component-based criterion is not supported for op: " + this.op);
                }
                SingularPersistentAttributeEmbedded embeddedAttribute = (SingularPersistentAttributeEmbedded)persistentAttribute;
                List<NonIdPersistentAttribute> attributes = embeddedAttribute.getEmbeddedDescriptor().getPersistentAttributes();
                for (PersistentAttributeDescriptor persistentAttributeDescriptor : attributes) {
                    Object attributeValue = embeddedAttribute.getEmbeddedDescriptor().getPropertyValue(this.value, persistentAttributeDescriptor.getName());
                    parameters.addWhereWithParam(alias, propertyName + "_" + persistentAttributeDescriptor.getName(), this.op, attributeValue);
                }
            } else {
                parameters.addWhereWithParam(alias, propertyName, this.op, this.value);
            }
        } else {
            if (!"=".equals(this.op) && !"<>".equals(this.op)) {
                throw new AuditException("This type of operation: " + this.op + " (" + entityName + "." + propertyName + ") isn't supported and can't be used in queries.");
            }
            Object id = relatedEntity.getIdMapper().mapToIdFromEntity(this.value);
            relatedEntity.getIdMapper().addIdEqualsToQuery(parameters, id, alias, null, "=".equals(this.op));
        }
    }

    private PersistentAttributeDescriptor getPersistentAttribute(SessionImplementor session, String entityName, String attributeName) {
        EntityTypeDescriptor entityDescriptor = session.getSessionFactory().getMetamodel().findEntityDescriptor(entityName);
        return entityDescriptor.findPersistentAttribute(attributeName);
    }
}

