/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.internal.impl;

import java.util.List;
import java.util.Set;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.query.internal.impl.AbstractAuditQuery;
import org.hibernate.query.Query;

public class EntitiesAtRevisionQuery
extends AbstractAuditQuery {
    private final Number revision;
    private final boolean includeDeletions;

    public EntitiesAtRevisionQuery(AuditReaderImplementor versionsReader, Class<?> cls, Number revision, boolean includeDeletions) {
        super(versionsReader, cls);
        this.revision = revision;
        this.includeDeletions = includeDeletions;
    }

    public EntitiesAtRevisionQuery(AuditReaderImplementor versionsReader, Class<?> cls, String entityName, Number revision, boolean includeDeletions) {
        super(versionsReader, cls, entityName);
        this.revision = revision;
        this.includeDeletions = includeDeletions;
    }

    @Override
    public List list() {
        String revisionPropertyPath = this.getOptions().getRevisionNumberPath();
        String originalIdPropertyName = this.getOptions().getOriginalIdPropName();
        MiddleIdData referencedIdData = new MiddleIdData(this.getEntityConfiguration().getIdMappingData(), null, this.getEntityName(), this.getAuditEntityName());
        this.getOptions().getAuditStrategy().addEntityAtRevisionRestriction(this.getOptions(), this.getQueryBuilder(), this.getQueryBuilder().getRootParameters(), revisionPropertyPath, this.getOptions().getRevisionEndFieldName(), true, referencedIdData, revisionPropertyPath, originalIdPropertyName, "e__", "e2__", true);
        if (!this.includeDeletions) {
            this.getQueryBuilder().getRootParameters().addWhereWithParam(this.getOptions().getRevisionTypePropName(), "<>", (Object)RevisionType.DEL);
        }
        this.applyCriterions("e__");
        Query query = this.buildQuery();
        Set<String> params = query.getParameterMetadata().getNamedParameterNames();
        if (params.contains("revision")) {
            query.setParameter("revision", (Object)this.revision);
        }
        List queryResult = query.list();
        return this.applyProjections(queryResult, this.revision);
    }
}

