/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.internal.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.JoinType;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.ExtendedPropertyMapper;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoNumberReader;
import org.hibernate.envers.query.AuditAssociationQuery;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.internal.impl.AbstractAuditQuery;
import org.hibernate.proxy.HibernateProxy;

public class RevisionsOfEntityQuery
extends AbstractAuditQuery {
    private final boolean selectEntitiesOnly;
    private final boolean selectDeletedEntities;
    private final boolean selectRevisionInfoOnly;
    private final boolean includePropertyChanges;
    private final RevisionInfoNumberReader revisionInfoNumberReader;

    public RevisionsOfEntityQuery(AuditReaderImplementor versionsReader, Class<?> clazz, boolean selectEntitiesOnly, boolean selectDeletedEntities, boolean selectRevisionInfoOnly, boolean includePropertyChanges) {
        super(versionsReader, clazz);
        this.selectEntitiesOnly = selectEntitiesOnly;
        this.selectDeletedEntities = selectDeletedEntities;
        this.selectRevisionInfoOnly = selectRevisionInfoOnly && !selectEntitiesOnly;
        this.includePropertyChanges = includePropertyChanges;
        this.revisionInfoNumberReader = versionsReader.getAuditService().getRevisionInfoNumberReader();
    }

    public RevisionsOfEntityQuery(AuditReaderImplementor versionsReader, Class<?> clazz, String entityName, boolean selectEntitiesOnly, boolean selectDeletedEntities, boolean selectRevisionInfoOnly, boolean includePropertyChanges) {
        super(versionsReader, clazz, entityName);
        this.selectEntitiesOnly = selectEntitiesOnly;
        this.selectDeletedEntities = selectDeletedEntities;
        this.selectRevisionInfoOnly = selectRevisionInfoOnly && !selectEntitiesOnly;
        this.includePropertyChanges = includePropertyChanges;
        this.revisionInfoNumberReader = versionsReader.getAuditService().getRevisionInfoNumberReader();
    }

    private Number getRevisionNumber(Map versionsEntity) {
        String originalId = this.getOptions().getOriginalIdPropName();
        String revisionPropertyName = this.getOptions().getRevisionFieldName();
        Object revisionInfoObject = ((Map)versionsEntity.get(originalId)).get(revisionPropertyName);
        if (revisionInfoObject instanceof HibernateProxy) {
            return (Number)((HibernateProxy)revisionInfoObject).getHibernateLazyInitializer().getIdentifier();
        }
        return this.revisionInfoNumberReader.getRevisionNumber(revisionInfoObject);
    }

    @Override
    public List list() throws AuditException {
        if (!this.selectDeletedEntities) {
            this.getQueryBuilder().getRootParameters().addWhereWithParam(this.getOptions().getRevisionTypePropName(), "<>", (Object)RevisionType.DEL);
        }
        this.applyCriterions("e__");
        if (!this.hasProjection() && !this.hasOrder()) {
            String revisionPropertyPath = this.getOptions().getRevisionNumberPath();
            this.getQueryBuilder().addOrder("e__", revisionPropertyPath, true);
        }
        if (!this.selectEntitiesOnly) {
            this.getQueryBuilder().addFrom(this.getOptions().getRevisionInfoEntityName(), "r", true);
            this.getQueryBuilder().getRootParameters().addWhere(this.getOptions().getRevisionNumberPath(), true, "=", "r.id", false);
        }
        return this.getQueryResults();
    }

    @Override
    public AuditAssociationQuery<? extends AuditQuery> traverseRelation(String associationName, JoinType joinType) {
        throw new UnsupportedOperationException("Not yet implemented for revisions of entity queries");
    }

    private boolean isEntityUsingModifiedFlags() {
        ExtendedPropertyMapper propertyMapper = this.getEntityConfiguration().getPropertyMapper();
        for (PropertyData propertyData : propertyMapper.getProperties().keySet()) {
            if (!propertyData.isUsingModifiedFlag()) continue;
            return true;
        }
        return false;
    }

    private Set<String> getChangedPropertyNames(Map<String, Object> dataMap, Object revisionType) {
        HashSet<String> changedPropertyNames = new HashSet<String>();
        if (revisionType == RevisionType.MOD) {
            String modifiedFlagSuffix = this.getOptions().getModifiedFlagSuffix();
            for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                String key = entry.getKey();
                if (!key.endsWith(modifiedFlagSuffix) || entry.getValue() == null || !Boolean.parseBoolean(entry.getValue().toString())) continue;
                changedPropertyNames.add(key.substring(0, key.length() - modifiedFlagSuffix.length()));
            }
        }
        return changedPropertyNames;
    }

    private List getQueryResults() {
        List queryResults = this.buildAndExecuteQuery();
        if (this.hasProjection()) {
            return queryResults;
        }
        if (this.selectRevisionInfoOnly) {
            return queryResults.stream().map(e -> ((Object[])e)[1]).collect(Collectors.toList());
        }
        ArrayList<Object> entities = new ArrayList<Object>();
        if (this.selectEntitiesOnly) {
            for (Object row : queryResults) {
                Map versionsEntity = (Map)row;
                entities.add(this.getQueryResultRowValue(versionsEntity, null, this.getEntityName()));
            }
        } else {
            for (Object row : queryResults) {
                Object[] rowArray = (Object[])row;
                Map versionsEntity = (Map)rowArray[0];
                Object revisionData = rowArray[1];
                entities.add(this.getQueryResultRowValue(versionsEntity, revisionData, this.getEntityName()));
            }
        }
        return entities;
    }

    private Object getQueryResultRowValue(Map versionsData, Object revisionData, String entityName) {
        Number revision = this.getRevisionNumber(versionsData);
        Object entity = this.getEntityInstantiator().createInstanceFromVersionsEntity(entityName, versionsData, revision);
        if (this.selectEntitiesOnly) {
            return entity;
        }
        Object revisionType = versionsData.get(this.getOptions().getRevisionTypePropName());
        if (!this.includePropertyChanges) {
            return new Object[]{entity, revisionData, revisionType};
        }
        if (!this.isEntityUsingModifiedFlags()) {
            throw new AuditException(String.format(Locale.ROOT, "The specified entity [%s] does not support or use modified flags.", this.getEntityConfiguration().getEntityClassName()));
        }
        Set<String> changedPropertyNames = this.getChangedPropertyNames(versionsData, revisionType);
        return new Object[]{entity, revisionData, revisionType, changedPropertyNames};
    }
}

