/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.strategy.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.persistence.metamodel.Type;
import org.dom4j.Element;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.boot.spi.AuditServiceOptions;
import org.hibernate.envers.configuration.internal.metadata.MetadataTools;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.synchronization.SessionCacheCleaner;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.strategy.spi.MappingContext;
import org.hibernate.event.spi.EventSource;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.InheritanceStrategy;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.UpdateToJdbcUpdateConverter;
import org.hibernate.sql.ast.produce.spi.SqlAstUpdateDescriptor;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.LiteralParameter;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.BasicExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.type.spi.BasicType;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class ValidityAuditStrategy
implements AuditStrategy {
    private Getter revisionTimestampGetter;
    private final SessionCacheCleaner sessionCacheCleaner = new SessionCacheCleaner();

    @Override
    public void addAdditionalColumns(MappingContext mappingContext) {
        Element endRevMapping = (Element)mappingContext.getRevisionEntityMapping().clone();
        endRevMapping.setName("many-to-one");
        endRevMapping.addAttribute("name", mappingContext.getOptions().getRevisionEndFieldName());
        MetadataTools.addOrModifyColumn(endRevMapping, mappingContext.getOptions().getRevisionEndFieldName());
        mappingContext.getAuditEntityMapping().add(endRevMapping);
        if (mappingContext.getOptions().isRevisionEndTimestampEnabled()) {
            Element timestampProperty = MetadataTools.addProperty(mappingContext.getAuditEntityMapping(), mappingContext.getOptions().getRevisionEndTimestampFieldName(), this.getTimestampTypeName(mappingContext), true, true, false);
            MetadataTools.addColumn(timestampProperty, mappingContext.getOptions().getRevisionEndTimestampFieldName(), null, null, null, null, null, null);
        }
    }

    @Override
    public void postInitialize(Class<?> revisionInfoClass, PropertyData timestampData, ServiceRegistry serviceRegistry) {
        Getter revisionTimestampGetter = ReflectionTools.getGetter(revisionInfoClass, timestampData, serviceRegistry);
        this.setRevisionTimestampGetter(revisionTimestampGetter);
    }

    @Override
    public void perform(Session session, String entityName, AuditService auditService, Object id, Object data, Object revision) {
        String auditedEntityName = auditService.getAuditEntityName(entityName);
        AuditServiceOptions options = auditService.getOptions();
        boolean reuseIdentifierNames = options.isAllowIdentifierReuseEnabled();
        session.save(auditedEntityName, data);
        if (reuseIdentifierNames || this.getRevisionType(options, data) != RevisionType.ADD) {
            ((EventSource)session).getActionQueue().registerProcess(sessionImplementor -> {
                BasicExecutionContext executionContext = new BasicExecutionContext(sessionImplementor);
                List<SqlAstUpdateDescriptor> updateDescriptors = this.getUpdateDescriptors(entityName, auditedEntityName, sessionImplementor, auditService, id, revision);
                if (updateDescriptors.isEmpty()) {
                    throw new AuditException(String.format(Locale.ROOT, "Failed to build update statements for entity %s and id %s", auditedEntityName, id));
                }
                for (SqlAstUpdateDescriptor updateDescriptor : updateDescriptors) {
                    int rowsAffected = JdbcMutationExecutor.WITH_AFTER_STATEMENT_CALL.execute(UpdateToJdbcUpdateConverter.createJdbcUpdate(updateDescriptor.getSqlAstStatement(), (SessionFactoryImplementor)executionContext.getSession().getSessionFactory()), JdbcParameterBindings.NO_BINDINGS, executionContext);
                    if (rowsAffected == 1) continue;
                    RevisionType revisionType = this.getRevisionType(options, data);
                    if (reuseIdentifierNames && revisionType == RevisionType.ADD) continue;
                    throw new AuditException(String.format("Cannot update previous revision for entity %s and id %s", auditedEntityName, id));
                }
            });
        }
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, data);
    }

    @Override
    public void performCollectionChange(Session session, String entityName, String propertyName, AuditService auditService, PersistentCollectionChangeData persistentCollectionChangeData, Object revision) {
        AuditServiceOptions options = auditService.getOptions();
        QueryBuilder qb = new QueryBuilder(persistentCollectionChangeData.getEntityName(), "ee__", ((SharedSessionContractImplementor)((Object)session)).getFactory());
        String originalIdPropName = options.getOriginalIdPropName();
        Map originalId = (Map)persistentCollectionChangeData.getData().get(originalIdPropName);
        String revisionFieldName = options.getRevisionFieldName();
        String revisionTypePropName = options.getRevisionTypePropName();
        String ordinalPropName = options.getEmbeddableSetOrdinalPropertyName();
        for (Map.Entry originalIdEntry : originalId.entrySet()) {
            if (revisionFieldName.equals(originalIdEntry.getKey()) || revisionTypePropName.equals(originalIdEntry.getKey()) || ordinalPropName.equals(originalIdEntry.getKey())) continue;
            qb.getRootParameters().addWhereWithParam(originalIdPropName + "." + (String)originalIdEntry.getKey(), true, "=", originalIdEntry.getValue());
        }
        SessionFactoryImplementor sessionFactory = ((SessionImplementor)session).getFactory();
        EntityTypeDescriptor entityDescriptor = sessionFactory.getMetamodel().findEntityDescriptor(entityName);
        entityDescriptor.visitAttributes(attribute -> {
            PluralPersistentAttribute pluralAttribute;
            if (attribute.getName().equals(propertyName) && attribute.isCollection() && (pluralAttribute = (PluralPersistentAttribute)attribute).getElementType().getPersistenceType().equals((Object)Type.PersistenceType.EMBEDDABLE)) {
                for (Map.Entry<String, Object> dataEntry : persistentCollectionChangeData.getData().entrySet()) {
                    if (originalIdPropName.equals(dataEntry.getKey())) continue;
                    if (dataEntry.getValue() != null) {
                        qb.getRootParameters().addWhereWithParam(dataEntry.getKey(), true, "=", dataEntry.getValue());
                        continue;
                    }
                    qb.getRootParameters().addNullRestriction(dataEntry.getKey(), true);
                }
            }
        });
        this.addEndRevisionNullRestriction(options, qb.getRootParameters());
        List<Object> l = qb.toQuery((SharedSessionContractImplementor)((Object)session)).setLockOptions(LockOptions.UPGRADE).list();
        if (l.size() > 0) {
            this.updateLastRevision(session, options, l, originalId, persistentCollectionChangeData.getEntityName(), revision);
        }
        session.save(persistentCollectionChangeData.getEntityName(), persistentCollectionChangeData.getData());
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, persistentCollectionChangeData.getData());
    }

    @Override
    public void addEntityAtRevisionRestriction(AuditServiceOptions options, QueryBuilder rootQueryBuilder, Parameters parameters, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData idData, String revisionPropertyPath, String originalIdPropertyName, String alias1, String alias2, boolean inclusive) {
        this.addRevisionRestriction(parameters, revisionProperty, revisionEndProperty, addAlias, inclusive);
    }

    @Override
    public void addAssociationAtRevisionRestriction(QueryBuilder rootQueryBuilder, Parameters parameters, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData referencingIdData, String versionsMiddleEntityName, String eeOriginalIdPropertyPath, String revisionPropertyPath, String originalIdPropertyName, String alias1, boolean inclusive, MiddleComponentData ... componentDatas) {
        this.addRevisionRestriction(parameters, revisionProperty, revisionEndProperty, addAlias, inclusive);
    }

    public void setRevisionTimestampGetter(Getter revisionTimestampGetter) {
        this.revisionTimestampGetter = revisionTimestampGetter;
    }

    private void addEndRevisionNullRestriction(AuditServiceOptions options, Parameters rootParameters) {
        rootParameters.addWhere(options.getRevisionEndFieldName(), true, "is", "null", false);
    }

    private void addRevisionRestriction(Parameters rootParameters, String revisionProperty, String revisionEndProperty, boolean addAlias, boolean inclusive) {
        Parameters subParm = rootParameters.addSubParameters("or");
        rootParameters.addWhereWithNamedParam(revisionProperty, addAlias, inclusive ? "<=" : "<", "revision");
        subParm.addWhereWithNamedParam(revisionEndProperty + ".id", addAlias, inclusive ? ">" : ">=", "revision");
        subParm.addWhere(revisionEndProperty, addAlias, "is", "null", false);
    }

    private RevisionType getRevisionType(AuditServiceOptions options, Object data) {
        return (RevisionType)((Object)((Map)data).get(options.getRevisionTypePropName()));
    }

    private void updateLastRevision(Session session, AuditServiceOptions options, List<Object> l, Object id, String auditedEntityName, Object revision) {
        Object previousData;
        if (l.size() == 1) {
            previousData = l.get(0);
            String revisionEndFieldName = options.getRevisionEndFieldName();
            ((Map)previousData).put(revisionEndFieldName, revision);
            if (options.isRevisionEndTimestampEnabled()) {
                String revEndTimestampFieldName = options.getRevisionEndTimestampFieldName();
                ((Map)previousData).put(revEndTimestampFieldName, this.getRevisionEndTimestampValue(revision, options));
            }
        } else {
            throw new RuntimeException("Cannot find previous revision for entity " + auditedEntityName + " and id " + id);
        }
        session.save(auditedEntityName, previousData);
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, previousData);
    }

    private Object getRevisionEndTimestampValue(Object revision, AuditServiceOptions options) {
        Object value = this.revisionTimestampGetter.get(revision);
        if (options.isNumericRevisionEndTimestampEnabled()) {
            if (Date.class.isInstance(value)) {
                return ((Date)value).getTime();
            }
            return value;
        }
        if (Date.class.isInstance(value)) {
            return value;
        }
        return new Date((Long)value);
    }

    private List<SqlAstUpdateDescriptor> getUpdateDescriptors(String entityName, String auditedEntityName, SessionImplementor session, AuditService auditService, Object id, Object revision) {
        AuditServiceOptions options = auditService.getOptions();
        EntityTypeDescriptor entityDescriptor = this.getEntityDescriptor(entityName, session);
        ArrayList<SqlAstUpdateDescriptor> statements = new ArrayList<SqlAstUpdateDescriptor>();
        if (options.isRevisionEndTimestampEnabled() && !options.isRevisionEndTimestampLegacyBehaviorEnabled() && entityDescriptor.getHierarchy().getInheritanceStrategy().equals((Object)InheritanceStrategy.JOINED)) {
            while (entityDescriptor.getSuperclassType() != null) {
                statements.add(this.buildNonRootEntityUpdateDescriptor(entityName, auditedEntityName, session, auditService, id, revision));
                entityName = entityDescriptor.getSuperclassType().getNavigableName();
                auditedEntityName = auditService.getAuditEntityName(entityName);
                entityDescriptor = this.getEntityDescriptor(entityName, session);
            }
        }
        statements.add(this.buildUpdateDescriptor(entityName, auditedEntityName, session, auditService, id, revision));
        return statements;
    }

    private SqlAstUpdateDescriptor buildUpdateDescriptor(String entityName, String auditedEntityName, SessionImplementor session, AuditService auditService, Object id, Object revision) {
        SessionFactoryImplementor sessionFactory = session.getSessionFactory();
        EntityTypeDescriptor entityDescriptor = this.getEntityDescriptor(entityName, session);
        EntityTypeDescriptor rootEntityDescriptor = entityDescriptor.getHierarchy().getRootEntityType();
        EntityTypeDescriptor auditedEntityDescriptor = this.getEntityDescriptor(auditedEntityName, session);
        EntityTypeDescriptor rootAuditedEntityDescriptor = auditedEntityDescriptor.getHierarchy().getRootEntityType();
        AuditServiceOptions options = auditService.getOptions();
        TableReference tableReference = this.getUpdateTableReference(rootEntityDescriptor, rootAuditedEntityDescriptor, auditedEntityDescriptor);
        UpdateStatement.UpdateStatementBuilder builder = new UpdateStatement.UpdateStatementBuilder(tableReference);
        Number revisionNumber = auditService.getRevisionInfoNumberReader().getRevisionNumber(revision);
        rootAuditedEntityDescriptor.findPersistentAttribute(options.getRevisionEndFieldName()).dehydrate(revisionNumber, (jdbcValue, type, boundColumn) -> {
            if (boundColumn.getSourceTable().equals(tableReference.getTable())) {
                builder.addAssignment(new Assignment(new ColumnReference(boundColumn), new LiteralParameter(jdbcValue, boundColumn.getExpressableType(), Clause.UPDATE, session.getFactory().getTypeConfiguration())));
            }
        }, Clause.UPDATE, session);
        if (options.isRevisionEndTimestampEnabled()) {
            rootAuditedEntityDescriptor.findPersistentAttribute(options.getRevisionEndTimestampFieldName()).dehydrate(this.getRevisionEndTimestampValue(revision, options), (jdbcValue, type, boundColumn) -> {
                if (boundColumn.getSourceTable().equals(tableReference.getTable())) {
                    builder.addAssignment(new Assignment(new ColumnReference(boundColumn), new LiteralParameter(jdbcValue, boundColumn.getExpressableType(), Clause.UPDATE, session.getFactory().getTypeConfiguration())));
                }
            }, Clause.UPDATE, session);
        }
        this.applyUpdateWhereCommon(builder, rootEntityDescriptor, rootAuditedEntityDescriptor, options, session, id, revisionNumber);
        auditedEntityDescriptor.findPersistentAttribute(options.getRevisionEndFieldName()).dehydrate(null, (jdbcValue, type, boundColumn) -> builder.addRestriction(new NullnessPredicate(new ColumnReference(boundColumn), false)), Clause.WHERE, session);
        return builder.createUpdateDescriptor();
    }

    private SqlAstUpdateDescriptor buildNonRootEntityUpdateDescriptor(String entityName, String auditedEntityName, SessionImplementor session, AuditService auditService, Object id, Object revision) {
        SessionFactoryImplementor sessionFactory = session.getSessionFactory();
        AuditServiceOptions options = auditService.getOptions();
        EntityTypeDescriptor entityDescriptor = this.getEntityDescriptor(entityName, session);
        EntityTypeDescriptor auditedEntityDescriptor = this.getEntityDescriptor(auditedEntityName, session);
        TableReference tableReference = this.getUpdateTableReference(entityDescriptor, auditedEntityDescriptor, auditedEntityDescriptor);
        UpdateStatement.UpdateStatementBuilder builder = new UpdateStatement.UpdateStatementBuilder(tableReference);
        NonIdPersistentAttribute revisionEndTimestampAttribute = auditedEntityDescriptor.findPersistentAttribute(options.getRevisionEndTimestampFieldName());
        revisionEndTimestampAttribute.dehydrate(this.getRevisionEndTimestampValue(revision, options), (jdbcValue, type, boundColumn) -> builder.addAssignment(new Assignment(new ColumnReference(boundColumn), new LiteralParameter(jdbcValue, boundColumn.getExpressableType(), Clause.UPDATE, session.getFactory().getTypeConfiguration()))), Clause.UPDATE, session);
        this.applyUpdateWhereCommon(builder, entityDescriptor, auditedEntityDescriptor, options, session, id, auditService.getRevisionInfoNumberReader().getRevisionNumber(revision));
        revisionEndTimestampAttribute.dehydrate(null, (jdbcValue, type, boundColumn) -> builder.addRestriction(new NullnessPredicate(new ColumnReference(boundColumn), false)), Clause.WHERE, session);
        return builder.createUpdateDescriptor();
    }

    private void applyUpdateWhereCommon(final UpdateStatement.UpdateStatementBuilder builder, EntityTypeDescriptor entityDescriptor, EntityTypeDescriptor auditedEntityDescriptor, final AuditServiceOptions options, final SessionImplementor session, Object id, final Number revisionNumber) {
        EntityIdentifier productionIdentifier = entityDescriptor.getHierarchy().getIdentifierDescriptor();
        Junction identifierJunction = new Junction(Junction.Nature.CONJUNCTION);
        productionIdentifier.dehydrate(productionIdentifier.unresolve(id, session), (jdbcValue, type, boundColumn) -> identifierJunction.add(new ComparisonPredicate(new ColumnReference(boundColumn), ComparisonOperator.EQUAL, new LiteralParameter(jdbcValue, boundColumn.getExpressableType(), Clause.WHERE, session.getFactory().getTypeConfiguration()))), Clause.WHERE, session);
        builder.addRestriction(identifierJunction);
        auditedEntityDescriptor.getIdentifierDescriptor().visitColumns(new BiConsumer<SqlExpressableType, Column>(){

            @Override
            public void accept(SqlExpressableType sqlExpressableType, Column column) {
                if (column.getExpression().equals(options.getRevisionFieldName())) {
                    builder.addRestriction(new ComparisonPredicate(new ColumnReference(column), ComparisonOperator.NOT_EQUAL, new LiteralParameter(revisionNumber, column.getExpressableType(), Clause.WHERE, session.getFactory().getTypeConfiguration())));
                }
            }
        }, Clause.IRRELEVANT, session.getFactory().getTypeConfiguration());
    }

    private EntityTypeDescriptor getEntityDescriptor(String entityName, SessionImplementor sessionImplementor) {
        return sessionImplementor.getFactory().getMetamodel().findEntityDescriptor(entityName);
    }

    private TableReference getUpdateTableReference(EntityTypeDescriptor rootEntityDescriptor, EntityTypeDescriptor rootAuditedEntityDescriptor, EntityTypeDescriptor auditedEntityDescriptor) {
        if (rootEntityDescriptor.getHierarchy().getInheritanceStrategy().equals((Object)InheritanceStrategy.UNION)) {
            return new TableReference(auditedEntityDescriptor.getPrimaryTable(), null, false);
        }
        return new TableReference(rootAuditedEntityDescriptor.getPrimaryTable(), null, false);
    }

    private String getTimestampTypeName(MappingContext mappingContext) {
        if (mappingContext.getOptions().isNumericRevisionEndTimestampEnabled()) {
            return this.getBasicTypeSqlType(mappingContext.getDialect(), StandardSpiBasicTypes.LONG);
        }
        return this.getBasicTypeSqlType(mappingContext.getDialect(), StandardSpiBasicTypes.TIMESTAMP);
    }

    private String getBasicTypeSqlType(Dialect dialect, BasicType basicType) {
        return dialect.getTypeName(basicType.getSqlTypeDescriptor().getJdbcTypeCode());
    }
}

