/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionRecreateAction;
import org.hibernate.action.internal.CollectionRemoveAction;
import org.hibernate.action.internal.CollectionUpdateAction;
import org.hibernate.action.internal.QueuedOperationCollectionAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.Collections;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.service.spi.JpaBootstrapSensitive;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEntityEvent;
import org.hibernate.event.spi.FlushEntityEventListener;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.EntityPrinter;
import org.hibernate.internal.util.collections.IdentityMap;
import org.hibernate.internal.util.collections.LazyIterator;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.jboss.logging.Logger;

public abstract class AbstractFlushingEventListener
implements JpaBootstrapSensitive,
Serializable {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)AbstractFlushingEventListener.class.getName());
    private boolean jpaBootstrap;

    @Override
    public void wasJpaBootstrap(boolean wasJpaBootstrap) {
        this.jpaBootstrap = wasJpaBootstrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushEverythingToExecutions(FlushEvent event) throws HibernateException {
        LOG.trace("Flushing session");
        EventSource session = event.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        session.getInterceptor().preFlush(new LazyIterator(persistenceContext.getEntitiesByKey()));
        this.prepareEntityFlushes(session, persistenceContext);
        this.prepareCollectionFlushes(persistenceContext);
        persistenceContext.setFlushing(true);
        try {
            int entityCount = this.flushEntities(event, persistenceContext);
            int collectionCount = this.flushCollections(session, persistenceContext);
            event.setNumberOfEntitiesProcessed(entityCount);
            event.setNumberOfCollectionsProcessed(collectionCount);
        }
        finally {
            persistenceContext.setFlushing(false);
        }
        this.logFlushResults(event);
    }

    private void logFlushResults(FlushEvent event) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        EventSource session = event.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        LOG.debugf("Flushed: %s insertions, %s updates, %s deletions to %s objects", new Object[]{session.getActionQueue().numberOfInsertions(), session.getActionQueue().numberOfUpdates(), session.getActionQueue().numberOfDeletions(), persistenceContext.getNumberOfManagedEntities()});
        LOG.debugf("Flushed: %s (re)creations, %s updates, %s removals to %s collections", new Object[]{session.getActionQueue().numberOfCollectionCreations(), session.getActionQueue().numberOfCollectionUpdates(), session.getActionQueue().numberOfCollectionRemovals(), persistenceContext.getCollectionEntries().size()});
        new EntityPrinter(session.getFactory()).toString(persistenceContext.getEntitiesByKey().entrySet(), event.getSession());
    }

    private void prepareEntityFlushes(EventSource session, PersistenceContext persistenceContext) throws HibernateException {
        LOG.debug("Processing flush-time cascades");
        Object anything = this.getAnything();
        for (Map.Entry<Object, EntityEntry> me : persistenceContext.reentrantSafeEntityEntries()) {
            EntityEntry entry = me.getValue();
            Status status = entry.getStatus();
            if (status != Status.MANAGED && status != Status.SAVING && status != Status.READ_ONLY) continue;
            this.cascadeOnFlush(session, entry.getDescriptor(), me.getKey(), anything);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnFlush(EventSource session, EntityTypeDescriptor descriptor, Object object, Object anything) throws HibernateException {
        session.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadingAction(), CascadePoint.BEFORE_FLUSH, session, descriptor, object, anything);
        }
        finally {
            session.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected Object getAnything() {
        if (this.jpaBootstrap) {
            return new IdentityHashMap(10);
        }
        return null;
    }

    protected CascadingAction getCascadingAction() {
        if (this.jpaBootstrap) {
            return CascadingActions.PERSIST_ON_FLUSH;
        }
        return CascadingActions.SAVE_UPDATE;
    }

    private void prepareCollectionFlushes(PersistenceContext persistenceContext) throws HibernateException {
        LOG.debug("Dirty checking collections");
        for (Map.Entry entry : IdentityMap.concurrentEntries(persistenceContext.getCollectionEntries())) {
            ((CollectionEntry)entry.getValue()).preFlush((PersistentCollection)entry.getKey());
        }
    }

    private int flushEntities(FlushEvent event, PersistenceContext persistenceContext) throws HibernateException {
        LOG.trace("Flushing entities and processing referenced collections");
        EventSource source = event.getSession();
        Iterable<FlushEntityEventListener> flushListeners = source.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.FLUSH_ENTITY).listeners();
        Map.Entry<Object, EntityEntry>[] entityEntries = persistenceContext.reentrantSafeEntityEntries();
        int count = entityEntries.length;
        for (Map.Entry<Object, EntityEntry> me : entityEntries) {
            EntityEntry entry = me.getValue();
            Status status = entry.getStatus();
            if (status == Status.LOADING || status == Status.GONE) continue;
            FlushEntityEvent entityEvent = new FlushEntityEvent(source, me.getKey(), entry);
            for (FlushEntityEventListener listener : flushListeners) {
                listener.onFlushEntity(entityEvent);
            }
        }
        source.getActionQueue().sortActions();
        return count;
    }

    private int flushCollections(EventSource session, PersistenceContext persistenceContext) throws HibernateException {
        LOG.trace("Processing unreferenced collections");
        Map.Entry<K, V>[] entries = IdentityMap.concurrentEntries(persistenceContext.getCollectionEntries());
        int count = entries.length;
        for (Map.Entry me : entries) {
            CollectionEntry ce = (CollectionEntry)me.getValue();
            if (ce.isReached() || ce.isIgnore()) continue;
            Collections.processUnreachableCollection((PersistentCollection)me.getKey(), session);
        }
        LOG.trace("Scheduling collection removes/(re)creates/updates");
        ActionQueue actionQueue = session.getActionQueue();
        for (Map.Entry me : IdentityMap.concurrentEntries(persistenceContext.getCollectionEntries())) {
            PersistentCollection coll = (PersistentCollection)me.getKey();
            CollectionEntry ce = (CollectionEntry)me.getValue();
            if (ce.isDorecreate()) {
                session.getInterceptor().onCollectionRecreate((Object)coll, ce.getCurrentKey());
                actionQueue.addAction(new CollectionRecreateAction(coll, ce.getCurrentDescriptor(), ce.getCurrentKey(), (SharedSessionContractImplementor)session));
            }
            if (ce.isDoremove()) {
                session.getInterceptor().onCollectionRemove((Object)coll, ce.getLoadedKey());
                actionQueue.addAction(new CollectionRemoveAction(coll, ce.getLoadedCollectionDescriptor(), ce.getLoadedKey(), ce.isSnapshotEmpty(coll), (SharedSessionContractImplementor)session));
            }
            if (ce.isDoupdate()) {
                session.getInterceptor().onCollectionUpdate((Object)coll, ce.getLoadedKey());
                actionQueue.addAction(new CollectionUpdateAction(coll, ce.getLoadedCollectionDescriptor(), ce.getLoadedKey(), ce.isSnapshotEmpty(coll), session));
            }
            if (coll.wasInitialized() || !coll.hasQueuedOperations()) continue;
            actionQueue.addAction(new QueuedOperationCollectionAction(coll, ce.getLoadedCollectionDescriptor(), ce.getLoadedKey(), (SharedSessionContractImplementor)session));
        }
        actionQueue.sortCollectionActions();
        return count;
    }

    protected void performExecutions(EventSource session) {
        LOG.trace("Executing flush");
        try {
            session.getJdbcCoordinator().flushBeginning();
            session.getPersistenceContext().setFlushing(true);
            session.getActionQueue().prepareActions();
            session.getActionQueue().executeActions();
        }
        finally {
            session.getPersistenceContext().setFlushing(false);
            session.getJdbcCoordinator().flushEnding();
        }
    }

    protected void postFlush(SessionImplementor session) throws HibernateException {
        LOG.trace("Post flush");
        PersistenceContext persistenceContext = session.getPersistenceContext();
        persistenceContext.getCollectionsByKey().clear();
        persistenceContext.getBatchFetchQueue().clear();
        for (Map.Entry me : IdentityMap.concurrentEntries(persistenceContext.getCollectionEntries())) {
            CollectionEntry collectionEntry = (CollectionEntry)me.getValue();
            PersistentCollection persistentCollection = (PersistentCollection)me.getKey();
            collectionEntry.postFlush(persistentCollection);
            if (collectionEntry.getLoadedCollectionDescriptor() == null) {
                persistentCollection.unsetSession(session);
                persistenceContext.getCollectionEntries().remove(persistentCollection);
                continue;
            }
            CollectionKey collectionKey = new CollectionKey(collectionEntry.getLoadedCollectionDescriptor(), collectionEntry.getLoadedKey());
            persistenceContext.getCollectionsByKey().put(collectionKey, persistentCollection);
        }
    }

    protected void postPostFlush(SessionImplementor session) {
        session.getInterceptor().postFlush(new LazyIterator(session.getPersistenceContext().getEntitiesByKey()));
    }
}

