/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ObjectDeletedException;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractReassociateEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

public abstract class AbstractLockUpgradeEventListener
extends AbstractReassociateEventListener {
    private static final Logger log = CoreLogging.logger(AbstractLockUpgradeEventListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void upgradeLock(Object object, EntityEntry entry, LockOptions lockOptions, EventSource source) {
        LockMode requestedLockMode = lockOptions.getLockMode();
        if (!requestedLockMode.greaterThan(entry.getLockMode())) return;
        if (entry.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("attempted to lock a deleted instance", entry.getId(), entry.getDescriptor().getEntityName());
        }
        EntityTypeDescriptor entityDescriptor = entry.getDescriptor();
        if (log.isTraceEnabled()) {
            log.tracev("Locking {0} in mode: {1}", (Object)MessageHelper.infoString(entityDescriptor, entry.getId(), source.getFactory()), (Object)requestedLockMode);
        }
        boolean cachingEnabled = entityDescriptor.canWriteToCache();
        SoftLock lock = null;
        Object ck = null;
        try {
            if (cachingEnabled) {
                ck = entityDescriptor.getHierarchy().getEntityCacheAccess().generateCacheKey(entry.getId(), entityDescriptor.getHierarchy(), source.getFactory(), source.getTenantIdentifier());
                lock = entityDescriptor.getHierarchy().getEntityCacheAccess().lockItem(source, ck, entry.getVersion());
            }
            if (entityDescriptor.getHierarchy().getVersionDescriptor() != null && this.shouldForceVersionIncrement(requestedLockMode)) {
                Object nextVersion = entityDescriptor.forceVersionIncrement(entry.getId(), entry.getVersion(), source);
                entry.forceLocked(object, nextVersion);
            } else {
                entityDescriptor.lock(entry.getId(), entry.getVersion(), object, lockOptions, (SharedSessionContractImplementor)source);
            }
            entry.setLockMode(requestedLockMode);
            if (!cachingEnabled) return;
        }
        catch (Throwable throwable) {
            if (!cachingEnabled) throw throwable;
            entityDescriptor.getHierarchy().getEntityCacheAccess().unlockItem(source, ck, lock);
            throw throwable;
        }
        entityDescriptor.getHierarchy().getEntityCacheAccess().unlockItem(source, ck, lock);
    }

    protected boolean shouldForceVersionIncrement(LockMode requestedLockMode) {
        return requestedLockMode == LockMode.FORCE || requestedLockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT || requestedLockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT;
    }
}

