/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.LockMode;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.OnLockVisitor;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.internal.TypeHelper;
import org.jboss.logging.Logger;

public abstract class AbstractReassociateEventListener
implements Serializable {
    private static final Logger log = CoreLogging.logger(AbstractReassociateEventListener.class);

    protected final EntityEntry reassociate(AbstractEvent event, Object object, Object id, EntityTypeDescriptor entityDescriptor) {
        if (log.isTraceEnabled()) {
            log.tracev("Reassociating transient instance: {0}", (Object)MessageHelper.infoString(entityDescriptor, id, event.getSession().getFactory()));
        }
        EventSource source = event.getSession();
        EntityKey key = source.generateEntityKey(id, entityDescriptor);
        source.getPersistenceContext().checkUniqueness(key, object);
        Object[] values = entityDescriptor.getPropertyValues(object);
        TypeHelper.deepCopy(entityDescriptor, values, values, StateArrayContributor::isUpdatable);
        Object version = Versioning.getVersion(values, entityDescriptor);
        EntityEntry newEntry = source.getPersistenceContext().addEntity(object, entityDescriptor.getJavaTypeDescriptor().getMutabilityPlan().isMutable() ? Status.MANAGED : Status.READ_ONLY, values, key, version, LockMode.NONE, true, entityDescriptor, false);
        new OnLockVisitor(source, id, object).process(object, entityDescriptor);
        entityDescriptor.afterReassociate(object, source);
        return newEntry;
    }
}

