/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.List;
import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityEntryExtraState;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractReassociateEventListener;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.metamodel.model.domain.spi.VersionDescriptor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.internal.TypeHelper;

public abstract class AbstractSaveEventListener
extends AbstractReassociateEventListener
implements CallbackRegistryConsumer {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AbstractSaveEventListener.class);
    private CallbackRegistry callbackRegistry;

    @Override
    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    protected Object saveWithRequestedId(Object entity, Object requestedId, String entityName, Object anything, EventSource source) {
        this.callbackRegistry.preCreate(entity);
        return this.performSave(entity, requestedId, source.getEntityDescriptor(entityName, entity), false, anything, source, true);
    }

    protected Object saveWithGeneratedId(Object entity, String entityName, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        EntityTypeDescriptor entityDescriptor;
        EntityIdentifier identifierDescriptor;
        Object generatedId;
        this.callbackRegistry.preCreate(entity);
        if (entity instanceof SelfDirtinessTracker) {
            ((SelfDirtinessTracker)entity).$$_hibernate_clearDirtyAttributes();
        }
        if ((generatedId = (identifierDescriptor = (entityDescriptor = source.getEntityDescriptor(entityName, entity)).getHierarchy().getIdentifierDescriptor()).getIdentifierValueGenerator().generate(source, entity)) == null) {
            throw new IdentifierGenerationException("null id generated for:" + entity.getClass());
        }
        if (generatedId == IdentifierGeneratorHelper.SHORT_CIRCUIT_INDICATOR) {
            return source.getIdentifier(entity);
        }
        if (generatedId == IdentifierGeneratorHelper.POST_INSERT_INDICATOR) {
            return this.performSave(entity, null, entityDescriptor, true, anything, source, requiresImmediateIdAccess);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Generated identifier: %s, using strategy: %s", entityDescriptor.getIdentifierDescriptor().getJavaTypeDescriptor().extractLoggableRepresentation(generatedId), identifierDescriptor.getClass().getName());
        }
        return this.performSave(entity, generatedId, entityDescriptor, false, anything, source, true);
    }

    protected Object performSave(Object entity, Object id, EntityTypeDescriptor descriptor, boolean useIdentityColumn, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        EntityKey key;
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Saving {0}", MessageHelper.infoString(descriptor, id, source.getFactory()));
        }
        if (!useIdentityColumn) {
            key = source.generateEntityKey(id, descriptor);
            Object old = source.getPersistenceContext().getEntity(key);
            if (old != null) {
                if (source.getPersistenceContext().getEntry(old).getStatus() == Status.DELETED) {
                    source.forceFlush(source.getPersistenceContext().getEntry(old));
                } else {
                    throw new NonUniqueObjectException(id, descriptor.getEntityName());
                }
            }
            descriptor.setIdentifier(entity, id, source);
        } else {
            key = null;
        }
        if (this.invokeSaveLifecycle(entity, descriptor, source)) {
            return id;
        }
        return this.performSaveOrReplicate(entity, key, descriptor, useIdentityColumn, anything, source, requiresImmediateIdAccess);
    }

    protected boolean invokeSaveLifecycle(Object entity, EntityTypeDescriptor descriptor, EventSource source) {
        if (descriptor.implementsLifecycle()) {
            LOG.debug("Calling onSave()");
            if (((Lifecycle)entity).onSave(source)) {
                LOG.debug("Insertion vetoed by onSave()");
                return true;
            }
        }
        return false;
    }

    protected Object performSaveOrReplicate(Object entity, EntityKey key, EntityTypeDescriptor entityDescriptor, boolean useIdentityColumn, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        EntityEntryExtraState extraState;
        EntityEntry newEntry;
        Object id = key == null ? null : key.getIdentifier();
        boolean shouldDelayIdentityInserts = AbstractSaveEventListener.shouldDelayIdentityInserts(requiresImmediateIdAccess, source, entityDescriptor);
        EntityEntry original = source.getPersistenceContext().addEntry(entity, Status.SAVING, null, null, id, null, LockMode.WRITE, useIdentityColumn, entityDescriptor, false);
        this.cascadeBeforeSave(source, entityDescriptor, entity, anything);
        Object[] values = entityDescriptor.getPropertyValuesToInsert(entity, this.getMergeMap(anything), source);
        boolean substitute = this.substituteValuesIfNecessary(entity, id, values, entityDescriptor, source);
        if (entityDescriptor.hasCollections()) {
            boolean bl = substitute = substitute || this.visitCollectionsBeforeSave(entity, id, values, entityDescriptor.getPersistentAttributes(), source);
        }
        if (substitute) {
            entityDescriptor.setPropertyValues(entity, values);
        }
        TypeHelper.deepCopy(entityDescriptor, values, values, StateArrayContributor::isUpdatable);
        AbstractEntityInsertAction insert = this.addInsertAction(values, id, entity, entityDescriptor, useIdentityColumn, source, shouldDelayIdentityInserts);
        this.cascadeAfterSave(source, entityDescriptor, entity, anything);
        if (useIdentityColumn && insert.isEarlyInsert()) {
            if (!EntityIdentityInsertAction.class.isInstance(insert)) {
                throw new IllegalStateException("Insert should be using an identity column, but action is of unexpected type: " + insert.getClass().getName());
            }
            id = ((EntityIdentityInsertAction)insert).getGeneratedId();
            insert.handleNaturalIdPostSaveNotifications(id);
        }
        if ((newEntry = source.getPersistenceContext().getEntry(entity)) != original && (extraState = newEntry.getExtraState(EntityEntryExtraState.class)) == null) {
            newEntry.addExtraState(original.getExtraState(EntityEntryExtraState.class));
        }
        return id;
    }

    private static boolean shouldDelayIdentityInserts(boolean requiresImmediateIdAccess, EventSource source, EntityTypeDescriptor descriptor) {
        return AbstractSaveEventListener.shouldDelayIdentityInserts(requiresImmediateIdAccess, AbstractSaveEventListener.isPartOfTransaction(source), source.getHibernateFlushMode(), descriptor);
    }

    private static boolean shouldDelayIdentityInserts(boolean requiresImmediateIdAccess, boolean partOfTransaction, FlushMode flushMode, EntityTypeDescriptor entityDescriptor) {
        if (!entityDescriptor.getFactory().getSessionFactoryOptions().isPostInsertIdentifierDelayableEnabled()) {
            return false;
        }
        if (requiresImmediateIdAccess) {
            return false;
        }
        if (!partOfTransaction || flushMode == FlushMode.MANUAL || flushMode == FlushMode.COMMIT) {
            if (entityDescriptor.canIdentityInsertBeDelayed()) {
                return true;
            }
            LOG.debugf("Identity insert for entity [%s] should be delayed; however the persister requested early insert.", entityDescriptor.getEntityName());
            return false;
        }
        return false;
    }

    private static boolean isPartOfTransaction(EventSource source) {
        return source.isTransactionInProgress() && source.getTransactionCoordinator().isJoined();
    }

    private AbstractEntityInsertAction addInsertAction(Object[] values, Object id, Object entity, EntityTypeDescriptor descriptor, boolean useIdentityColumn, EventSource source, boolean shouldDelayIdentityInserts) {
        if (useIdentityColumn) {
            EntityIdentityInsertAction insert = new EntityIdentityInsertAction(values, entity, descriptor, this.isVersionIncrementDisabled(), source, shouldDelayIdentityInserts);
            source.getActionQueue().addAction(insert);
            return insert;
        }
        Object version = Versioning.getVersion(values, descriptor);
        EntityInsertAction insert = new EntityInsertAction(id, values, entity, version, descriptor, this.isVersionIncrementDisabled(), source);
        source.getActionQueue().addAction(insert);
        return insert;
    }

    protected Map getMergeMap(Object anything) {
        return null;
    }

    protected boolean isVersionIncrementDisabled() {
        return false;
    }

    protected boolean visitCollectionsBeforeSave(Object entity, Object id, Object[] values, List<PersistentAttributeDescriptor> attributes, EventSource source) {
        WrapVisitor visitor = new WrapVisitor(source);
        visitor.processEntityPropertyValues(values, attributes);
        return visitor.isSubstitutionRequired();
    }

    protected boolean substituteValuesIfNecessary(Object entity, Object id, Object[] values, EntityTypeDescriptor entityDescriptor, SessionImplementor source) {
        boolean substitute = source.getInterceptor().onSave(entity, id, values, entityDescriptor.getPropertyNames(), entityDescriptor.getPropertyJavaTypeDescriptors());
        VersionDescriptor versionDescriptor = entityDescriptor.getHierarchy().getVersionDescriptor();
        if (versionDescriptor != null) {
            substitute = Versioning.seedVersion(values, versionDescriptor, source) || substitute;
        }
        return substitute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeSave(EventSource source, EntityTypeDescriptor descriptor, Object entity, Object anything) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.BEFORE_INSERT_AFTER_DELETE, source, descriptor, entity, anything);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterSave(EventSource source, EntityTypeDescriptor descriptor, Object entity, Object anything) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.AFTER_INSERT_BEFORE_DELETE, source, descriptor, entity, anything);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected abstract CascadingAction getCascadeAction();

    protected EntityState getEntityState(Object entity, String entityName, EntityEntry entry, SessionImplementor source) {
        boolean traceEnabled = LOG.isTraceEnabled();
        if (entry != null) {
            if (entry.getStatus() != Status.DELETED) {
                if (traceEnabled) {
                    LOG.tracev("Persistent instance of: {0}", this.getLoggableName(entityName, entity));
                }
                return EntityState.PERSISTENT;
            }
            if (traceEnabled) {
                LOG.tracev("Deleted instance of: {0}", this.getLoggableName(entityName, entity));
            }
            return EntityState.DELETED;
        }
        if (ForeignKeys.isTransient(entityName, entity, this.getAssumedUnsaved(), source)) {
            if (traceEnabled) {
                LOG.tracev("Transient instance of: {0}", this.getLoggableName(entityName, entity));
            }
            return EntityState.TRANSIENT;
        }
        if (traceEnabled) {
            LOG.tracev("Detached instance of: {0}", this.getLoggableName(entityName, entity));
        }
        return EntityState.DETACHED;
    }

    protected String getLoggableName(String entityName, Object entity) {
        return entityName == null ? entity.getClass().getName() : entityName;
    }

    protected Boolean getAssumedUnsaved() {
        return null;
    }

    public static enum EntityState {
        PERSISTENT,
        TRANSIENT,
        DETACHED,
        DELETED;

    }
}

